Liferay.Loader.define('roles-admin-web$lodash-es@4.17.15/_createToPairs', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseToPairs from './_baseToPairs.js';
  import getTag from './_getTag.js';
  import mapToArray from './_mapToArray.js';
  import setToPairs from './_setToPairs.js';

  /** `Object#toString` result references. */
  var mapTag = '[object Map]',
      setTag = '[object Set]';

  /**
   * Creates a `_.toPairs` or `_.toPairsIn` function.
   *
   * @private
   * @param {Function} keysFunc The function to get the keys of a given object.
   * @returns {Function} Returns the new pairs function.
   */
  function createToPairs(keysFunc) {
    return function (object) {
      var tag = getTag(object);
      if (tag == mapTag) {
        return mapToArray(object);
      }
      if (tag == setTag) {
        return setToPairs(object);
      }
      return baseToPairs(object, keysFunc(object));
    };
  }

  export default createToPairs;
});
//# sourceMappingURL=_createToPairs.js.map