/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.roles.admin.web.internal.portlet;

import com.liferay.application.list.PanelAppRegistry;
import com.liferay.application.list.PanelCategoryRegistry;
import com.liferay.application.list.display.context.logic.PanelCategoryHelper;
import com.liferay.portal.kernel.exception.DuplicateRoleException;
import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.exception.RequiredRoleException;
import com.liferay.portal.kernel.exception.RoleAssignmentException;
import com.liferay.portal.kernel.exception.RoleNameException;
import com.liferay.portal.kernel.exception.RolePermissionsException;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocal;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocalCloseable;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.security.permission.comparator.ActionComparator;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.RoleService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.css-class-wrapper=portlet-users-admin", "com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.header-portlet-css=/css/main.css", "com.liferay.portlet.icon=/icons/roles_admin.png", "com.liferay.portlet.preferences-owned-by-group=true", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=50", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=Roles Admin", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.template-path=/META-INF/resources/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_roles_admin_web_portlet_RolesAdminPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class RolesAdminPortlet
extends MVCPortlet {
    private GroupService _groupService;
    @Reference
    private Http _http;
    private PanelAppRegistry _panelAppRegistry;
    private PanelCategoryRegistry _panelCategoryRegistry;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    private ResourcePermissionService _resourcePermissionService;
    private RoleLocalService _roleLocalService;
    private RoleService _roleService;
    private UserService _userService;

    public void deletePermission(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long roleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"roleId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        int scope = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"scope");
        String primKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"primKey");
        String actionId = ParamUtil.getString((PortletRequest)actionRequest, (String)"actionId");
        Role role = this._roleLocalService.getRole(roleId);
        String roleName = role.getName();
        if (roleName.equals("Administrator") || roleName.equals("Organization Administrator") || roleName.equals("Organization Owner") || roleName.equals("Owner") || roleName.equals("Site Administrator") || roleName.equals("Site Owner")) {
            throw new RolePermissionsException(roleName);
        }
        this._resourcePermissionService.removeResourcePermission(themeDisplay.getScopeGroupId(), themeDisplay.getCompanyId(), name, scope, primKey, roleId, actionId);
        SessionMessages.add((PortletRequest)actionRequest, (String)"permissionDeleted");
        String redirect = this._portal.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
        if (Validator.isNotNull((String)redirect)) {
            actionResponse.sendRedirect(redirect);
        }
    }

    public void deleteRole(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long roleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"roleId");
        this._roleService.deleteRole(roleId);
    }

    public void deleteRoles(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] deleteRoleIds;
        for (long roleId : deleteRoleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteRoleIds"), (long)0L)) {
            this._roleService.deleteRole(roleId);
        }
    }

    public Role editRole(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long roleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"roleId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        Map titleMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"title");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        String subtype = ParamUtil.getString((PortletRequest)actionRequest, (String)"subtype");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Role.class.getName(), (PortletRequest)actionRequest);
        if (roleId <= 0L) {
            int type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type", (int)1);
            Role role = this._roleService.addRole(null, 0L, name, titleMap, descriptionMap, type, subtype, serviceContext);
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            redirect = this._http.setParameter(redirect, actionResponse.getNamespace() + "roleId", role.getRoleId());
            actionRequest.setAttribute("REDIRECT", (Object)redirect);
            SessionMessages.add((PortletRequest)actionRequest, (String)"roleCreated");
            actionResponse.sendRedirect(redirect);
            return role;
        }
        if (name.equals("Site Administrator")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            Role role = this._roleLocalService.getRole(roleId);
            boolean manageSubgroups = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"manageSubgroups");
            this.updateAction(role, themeDisplay.getScopeGroupId(), Group.class.getName(), "MANAGE_SUBGROUPS", manageSubgroups, 3, new String[0]);
        }
        return this._roleService.updateRole(roleId, name, titleMap, descriptionMap, subtype, serviceContext);
    }

    public void editRoleAssignments(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long roleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"roleId");
        Role role = this._roleLocalService.getRole(roleId);
        String roleName = role.getName();
        if (roleName.equals("Owner")) {
            throw new RoleAssignmentException(roleName);
        }
        long[] addUserIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"addUserIds"), (long)0L);
        long[] removeUserIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"removeUserIds"), (long)0L);
        if (!ArrayUtil.isEmpty((long[])addUserIds) || !ArrayUtil.isEmpty((long[])removeUserIds)) {
            try (ProxyModeThreadLocalCloseable proxyModeThreadLocalCloseable = new ProxyModeThreadLocalCloseable();){
                ProxyModeThreadLocal.setForceSync((boolean)true);
                this._userService.addRoleUsers(roleId, addUserIds);
                this._userService.unsetRoleUsers(roleId, removeUserIds);
            }
        }
        long[] addGroupIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"addGroupIds"), (long)0L);
        long[] removeGroupIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"removeGroupIds"), (long)0L);
        if (!ArrayUtil.isEmpty((long[])addGroupIds) || !ArrayUtil.isEmpty((long[])removeGroupIds)) {
            this._groupService.addRoleGroups(roleId, addGroupIds);
            this._groupService.unsetRoleGroups(roleId, removeGroupIds);
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        this.setAttributes((PortletRequest)resourceRequest);
        super.serveResource(resourceRequest, resourceResponse);
    }

    public void updateActions(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long roleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"roleId");
        Role role = this._roleLocalService.getRole(roleId);
        String roleName = role.getName();
        if (roleName.equals("Administrator") || roleName.equals("Organization Administrator") || roleName.equals("Organization Owner") || roleName.equals("Owner") || roleName.equals("Site Administrator") || roleName.equals("Site Owner")) {
            throw new RolePermissionsException(roleName);
        }
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        String[] relatedPortletResources = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"relatedPortletResources"));
        String[] modelResources = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"modelResources"));
        HashMap<String, List> resourceActionsMap = new HashMap<String, List>();
        if (Validator.isNotNull((String)portletResource)) {
            resourceActionsMap.put(portletResource, ResourceActionsUtil.getResourceActions((String)portletResource, null));
        }
        for (String relatedPortletResource : relatedPortletResources) {
            resourceActionsMap.put(relatedPortletResource, ResourceActionsUtil.getResourceActions((String)relatedPortletResource, null));
        }
        for (String modelResource : modelResources) {
            resourceActionsMap.put(modelResource, ResourceActionsUtil.getResourceActions(null, (String)modelResource));
        }
        int rootResourceScope = 1;
        String[] rootResourceGroupIds = null;
        Object[] selectedTargets = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"selectedTargets"));
        Object[] unselectedTargets = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"unselectedTargets"));
        for (Map.Entry entry : resourceActionsMap.entrySet()) {
            String selResource = (String)entry.getKey();
            List actions = (List)entry.getValue();
            actions = ListUtil.sort((List)actions, (Comparator)new ActionComparator(themeDisplay.getLocale()));
            for (String actionId : actions) {
                String target = selResource + actionId;
                boolean selected = ArrayUtil.contains((Object[])selectedTargets, (Object)target);
                if (!selected && !ArrayUtil.contains((Object[])unselectedTargets, (Object)target)) continue;
                String[] groupIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)("groupIds" + target)));
                groupIds = ArrayUtil.distinct((String[])groupIds);
                int scope = 1;
                if (role.getType() == 3 || role.getType() == 4 || role.getType() == 2) {
                    scope = 3;
                } else if (groupIds.length > 0) {
                    scope = 2;
                }
                this.updateAction(role, themeDisplay.getScopeGroupId(), selResource, actionId, selected, scope, groupIds);
                if (!selected || !actionId.equals("ACCESS_IN_CONTROL_PANEL")) continue;
                this.updateViewControlPanelPermission(role, themeDisplay.getScopeGroupId(), selResource, scope, groupIds);
                rootResourceScope = scope;
                rootResourceGroupIds = groupIds;
            }
        }
        if (rootResourceGroupIds != null) {
            this.updateViewRootResourcePermission(role, themeDisplay.getScopeGroupId(), portletResource, rootResourceScope, rootResourceGroupIds);
        }
        SessionMessages.add((PortletRequest)actionRequest, (String)"permissionsUpdated");
        String redirect = this._portal.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
        if (Validator.isNotNull((String)redirect)) {
            actionResponse.sendRedirect(redirect);
        }
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.setAttributes((PortletRequest)renderRequest);
        long roleId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"roleId");
        if (SessionErrors.contains((PortletRequest)renderRequest, (String)RequiredRoleException.class.getName()) && roleId < 1L) {
            this.include("/view.jsp", renderRequest, renderResponse);
        } else if (SessionErrors.contains((PortletRequest)renderRequest, (String)DuplicateRoleException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)RequiredRoleException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)RoleNameException.class.getName())) {
            this.include("/edit_role.jsp", renderRequest, renderResponse);
        } else if (SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchRoleException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (Class[])PrincipalException.getNestedClasses()) || SessionErrors.contains((PortletRequest)renderRequest, (String)RoleAssignmentException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)RolePermissionsException.class.getName())) {
            this.include("/error.jsp", renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected boolean isSessionErrorException(Throwable cause) {
        return cause instanceof DuplicateRoleException || cause instanceof NoSuchRoleException || cause instanceof PrincipalException || cause instanceof RequiredRoleException || cause instanceof RoleAssignmentException || cause instanceof RoleNameException || cause instanceof RolePermissionsException;
    }

    protected void setAttributes(PortletRequest portletRequest) {
        portletRequest.setAttribute("PANEL_APP_REGISTRY", (Object)this._panelAppRegistry);
        PanelCategoryHelper panelCategoryHelper = new PanelCategoryHelper(this._panelAppRegistry, this._panelCategoryRegistry);
        portletRequest.setAttribute("PANEL_CATEGORY_HELPER", (Object)panelCategoryHelper);
        portletRequest.setAttribute("PANEL_CATEGORY_REGISTRY", (Object)this._panelCategoryRegistry);
    }

    @Reference(unbind="-")
    protected void setGroupService(GroupService groupService) {
        this._groupService = groupService;
    }

    @Reference(unbind="-")
    protected void setPanelAppRegistry(PanelAppRegistry panelAppRegistry) {
        this._panelAppRegistry = panelAppRegistry;
    }

    @Reference(unbind="-")
    protected void setPanelCategoryRegistry(PanelCategoryRegistry panelCategoryRegistry) {
        this._panelCategoryRegistry = panelCategoryRegistry;
    }

    @Reference(unbind="-")
    protected void setResourcePermissionService(ResourcePermissionService resourcePermissionService) {
        this._resourcePermissionService = resourcePermissionService;
    }

    @Reference(unbind="-")
    protected void setRoleLocalService(RoleLocalService roleLocalService) {
        this._roleLocalService = roleLocalService;
    }

    @Reference(unbind="-")
    protected void setRoleService(RoleService roleService) {
        this._roleService = roleService;
    }

    @Reference(unbind="-")
    protected void setUserService(UserService userService) {
        this._userService = userService;
    }

    protected void updateAction(Role role, long groupId, String selResource, String actionId, boolean selected, int scope, String[] groupIds) throws Exception {
        long companyId = role.getCompanyId();
        long roleId = role.getRoleId();
        if (selected) {
            if (scope == 1) {
                this._resourcePermissionService.addResourcePermission(groupId, companyId, selResource, scope, String.valueOf(role.getCompanyId()), roleId, actionId);
            } else if (scope == 3) {
                this._resourcePermissionService.addResourcePermission(groupId, companyId, selResource, 3, String.valueOf(0L), roleId, actionId);
            } else if (scope == 2) {
                this._resourcePermissionService.removeResourcePermissions(groupId, companyId, selResource, 2, roleId, actionId);
                for (String curGroupId : groupIds) {
                    this._resourcePermissionService.addResourcePermission(groupId, companyId, selResource, 2, curGroupId, roleId, actionId);
                }
            }
        } else {
            this._resourcePermissionService.removeResourcePermissions(groupId, companyId, selResource, 1, roleId, actionId);
            this._resourcePermissionService.removeResourcePermissions(groupId, companyId, selResource, 3, roleId, actionId);
            this._resourcePermissionService.removeResourcePermissions(groupId, companyId, selResource, 2, roleId, actionId);
        }
    }

    protected void updateViewControlPanelPermission(Role role, long scopeGroupId, String portletId, int scope, String[] groupIds) throws Exception {
        PanelCategoryHelper panelCategoryHelper = new PanelCategoryHelper(this._panelAppRegistry, this._panelCategoryRegistry);
        String selResource = null;
        String actionId = null;
        if (panelCategoryHelper.containsPortlet(portletId, "control_panel") && role.getType() == 1) {
            selResource = "90";
            actionId = "VIEW_CONTROL_PANEL";
        } else if (panelCategoryHelper.containsPortlet(portletId, "site_administration")) {
            selResource = Group.class.getName();
            actionId = "VIEW_SITE_ADMINISTRATION";
        }
        if (selResource != null) {
            this.updateAction(role, scopeGroupId, selResource, actionId, true, scope, groupIds);
        }
    }

    protected void updateViewRootResourcePermission(Role role, long scopeGroupId, String portletId, int scope, String[] groupIds) throws Exception {
        List actions;
        String modelResource = ResourceActionsUtil.getPortletRootModelResource((String)portletId);
        if (modelResource != null && (actions = ResourceActionsUtil.getModelResourceActions((String)modelResource)).contains("VIEW")) {
            this.updateAction(role, scopeGroupId, modelResource, "VIEW", true, scope, groupIds);
        }
    }
}

