/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.roles.admin.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.rolesadmin.search.RoleSearch;
import com.liferay.portlet.rolesadmin.search.RoleSearchTerms;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class SelectRoleManagementToolbarDisplayContext {
    private static final Log _log = LogFactoryUtil.getLog(SelectRoleManagementToolbarDisplayContext.class);
    private final String _eventName;
    private final HttpServletRequest _httpServletRequest;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private RoleSearch _roleSearch;
    private final int _roleType;

    public SelectRoleManagementToolbarDisplayContext(HttpServletRequest httpServletRequest, RenderRequest renderRequest, RenderResponse renderResponse, String eventName) {
        this._httpServletRequest = httpServletRequest;
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._eventName = eventName;
        this._roleType = ParamUtil.getInteger((HttpServletRequest)this._httpServletRequest, (String)"roleType", (int)1);
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public PortletURL getPortletURL() {
        String organizationIds;
        String organizationId;
        long groupId;
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/select_role.jsp");
        portletURL.setParameter("roleType", String.valueOf(this._roleType));
        User selUser = this._getSelectedUser();
        if (selUser != null) {
            portletURL.setParameter("p_u_i_d", String.valueOf(selUser.getUserId()));
        }
        portletURL.setParameter("eventName", this._eventName);
        Object[] keywords = ParamUtil.getStringValues((HttpServletRequest)this._httpServletRequest, (String)"keywords");
        if (ArrayUtil.isNotEmpty((Object[])keywords)) {
            portletURL.setParameter("keywords", (String)keywords[keywords.length - 1]);
        }
        if ((groupId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"groupId")) != 0L) {
            portletURL.setParameter("groupId", String.valueOf(groupId));
        }
        if (Validator.isNotNull((String)(organizationId = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"organizationId")))) {
            portletURL.setParameter("organizationId", organizationId);
        }
        if (Validator.isNotNull((String)(organizationIds = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"organizationIds")))) {
            portletURL.setParameter("organizationIds", organizationIds);
        }
        int step = ParamUtil.getInteger((HttpServletRequest)this._httpServletRequest, (String)"step", (int)1);
        portletURL.setParameter("step", String.valueOf(step));
        return portletURL;
    }

    public SearchContainer getRoleSearchContainer(boolean filterManageableRoles) throws Exception {
        return this.getRoleSearchContainer(filterManageableRoles, 0L);
    }

    public SearchContainer getRoleSearchContainer(boolean filterManageableRoles, long groupId) throws Exception {
        if (this._roleSearch != null) {
            return this._roleSearch;
        }
        RoleSearch roleSearch = new RoleSearch((PortletRequest)this._renderRequest, this.getPortletURL());
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        RoleSearchTerms roleSearchTerms = (RoleSearchTerms)roleSearch.getSearchTerms();
        List results = null;
        int total = 0;
        if (filterManageableRoles) {
            results = RoleLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (String)roleSearchTerms.getKeywords(), (Integer[])new Integer[]{this._roleType}, (int)-1, (int)-1, (OrderByComparator)roleSearch.getOrderByComparator());
            results = groupId == 0L ? UsersAdminUtil.filterRoles((PermissionChecker)themeDisplay.getPermissionChecker(), (List)results) : UsersAdminUtil.filterGroupRoles((PermissionChecker)themeDisplay.getPermissionChecker(), (long)groupId, (List)results);
            total = results.size();
            results = ListUtil.subList((List)results, (int)roleSearch.getStart(), (int)roleSearch.getEnd());
        } else {
            total = RoleLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (String)roleSearchTerms.getKeywords(), (Integer[])new Integer[]{this._roleType});
            results = RoleLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (String)roleSearchTerms.getKeywords(), (Integer[])new Integer[]{this._roleType}, (int)roleSearch.getStart(), (int)roleSearch.getEnd(), (OrderByComparator)roleSearch.getOrderByComparator());
        }
        roleSearch.setResults(results);
        roleSearch.setTotal(total);
        this._roleSearch = roleSearch;
        return this._roleSearch;
    }

    public String getSearchActionURL() {
        PortletURL searchActionURL = this.getPortletURL();
        return searchActionURL.toString();
    }

    public List<ViewTypeItem> getViewTypeItems() {
        return new ViewTypeItemList(this.getPortletURL(), "list"){
            {
                this.addTableViewTypeItem();
            }
        };
    }

    private User _getSelectedUser() {
        try {
            return PortalUtil.getSelectedUser((HttpServletRequest)this._httpServletRequest);
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
            return null;
        }
    }
}

