/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.roles.admin.internal.exportimport.data.handler;

import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.DataLevel;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.xml.Element;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_roles_admin_web_portlet_RolesAdminPortlet"}, service={PortletDataHandler.class})
public class RolesAdminPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "roles_admin";
    public static final String SCHEMA_VERSION = "4.0.0";
    private final Set<String> _allSystemRoleNames = new HashSet<String>();
    @Reference
    private Portal _portal;
    @Reference
    private RoleLocalService _roleLocalService;

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    public boolean isSupportsDataStrategyCopyAsNew() {
        return false;
    }

    @Activate
    protected void activate() {
        this.setDataLevel(DataLevel.PORTAL);
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(Role.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "roles", true, true, new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "system-roles", true, false)}, Role.class.getName(), "referrer-class-name-all")});
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(RolesAdminPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        List roles = this._roleLocalService.getRoles(portletDataContext.getCompanyId());
        for (Role role : roles) {
            if (role.isSystem() || role.isTeam()) continue;
            this._roleLocalService.deleteRole(role);
        }
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPortalPermissions();
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        ActionableDynamicQuery actionableDynamicQuery = this._getRoleActionableDynamicQuery(portletDataContext, true);
        actionableDynamicQuery.performActions();
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPortalPermissions();
        Element rolesElement = portletDataContext.getImportDataGroupElement(Role.class);
        List roleElements = rolesElement.elements();
        for (Element roleElement : roleElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)roleElement);
        }
        return null;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._getRoleActionableDynamicQuery(portletDataContext, false);
        actionableDynamicQuery.performCount();
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    @Reference(unbind="-")
    protected void setPortal(Portal portal) {
        Collections.addAll(this._allSystemRoleNames, portal.getSystemOrganizationRoles());
        Collections.addAll(this._allSystemRoleNames, portal.getSystemRoles());
        Collections.addAll(this._allSystemRoleNames, portal.getSystemSiteRoles());
    }

    private ActionableDynamicQuery _getRoleActionableDynamicQuery(PortletDataContext portletDataContext, boolean export) {
        ExportActionableDynamicQuery actionableDynamicQuery = this._roleLocalService.getExportActionableDynamicQuery(portletDataContext);
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            long classNameId = this._portal.getClassNameId(Team.class);
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            dynamicQuery.add(classNameIdProperty.ne((Object)classNameId));
            if (!portletDataContext.getBooleanParameter(NAMESPACE, "system-roles")) {
                Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
                Property nameProperty = PropertyFactoryUtil.forName((String)"name");
                for (String roleName : this._allSystemRoleNames) {
                    conjunction.add(nameProperty.ne((Object)roleName));
                }
                dynamicQuery.add((Criterion)conjunction);
            }
        });
        ActionableDynamicQuery.PerformActionMethod performActionMethod = actionableDynamicQuery.getPerformActionMethod();
        RoleExportActionableDynamicQueryPerformActionMethod performActionMethodWrapper = new RoleExportActionableDynamicQueryPerformActionMethod((ActionableDynamicQuery.PerformActionMethod<Role>)performActionMethod, portletDataContext, export);
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)performActionMethodWrapper);
        return actionableDynamicQuery;
    }

    private class RoleExportActionableDynamicQueryPerformActionMethod
    implements ActionableDynamicQuery.PerformActionMethod<Role> {
        private final boolean _export;
        private final ActionableDynamicQuery.PerformActionMethod<Role> _performActionMethod;
        private final PortletDataContext _portletDataContext;

        public RoleExportActionableDynamicQueryPerformActionMethod(ActionableDynamicQuery.PerformActionMethod<Role> performActionMethod, PortletDataContext portletDataContext, boolean export) {
            this._performActionMethod = performActionMethod;
            this._portletDataContext = portletDataContext;
            this._export = export;
        }

        public void performAction(Role role) throws PortalException {
            if (!this._export || !this._portletDataContext.getBooleanParameter(RolesAdminPortletDataHandler.NAMESPACE, "system-roles") && RolesAdminPortletDataHandler.this._allSystemRoleNames.contains(role.getName())) {
                return;
            }
            this._performActionMethod.performAction((Object)role);
        }
    }
}

