/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.roles.admin.demo.data.creator.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.roles.admin.demo.data.creator.RoleDemoDataCreator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseRoleDemoDataCreator
implements RoleDemoDataCreator {
    @Reference
    protected CompanyLocalService companyLocalService;
    @Reference
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    @Reference
    protected RoleLocalService roleLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BaseRoleDemoDataCreator.class);
    private final List<Long> _roleIds = new CopyOnWriteArrayList<Long>();

    public void addPermissions(Role role, String permissionsXML, int scope, String primKey) throws PortalException {
        try {
            Document document = SAXReaderUtil.read((String)permissionsXML);
            Element rootElement = document.getRootElement();
            List resources = rootElement.elements("resource");
            for (Element resource : resources) {
                String resourceName = resource.elementText("resource-name");
                List actionIds = resource.elements("action-id");
                for (Element actionId : actionIds) {
                    this.addResourcePermission(role, resourceName, scope, primKey, actionId.getText());
                }
            }
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
    }

    public void addResourcePermission(Role role, String resourceName, int scope, String primKey, String actionId) throws PortalException {
        this.resourcePermissionLocalService.addResourcePermission(role.getCompanyId(), resourceName, scope, primKey, role.getRoleId(), actionId);
    }

    public Role createRole(long companyId, String roleName, int roleType) throws PortalException {
        Company company = this.companyLocalService.fetchCompany(companyId);
        User user = company.getDefaultUser();
        Role role = this.roleLocalService.addRole(user.getUserId(), null, 0L, roleName, null, null, roleType, null, null);
        this._roleIds.add(role.getRoleId());
        return role;
    }

    public void delete() throws PortalException {
        block3: {
            try {
                for (long roleId : this._roleIds) {
                    this._roleIds.remove(roleId);
                    this.roleLocalService.deleteRole(roleId);
                }
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)portalException);
            }
        }
    }

    public void removeResourcePermission(Role role, String resourceName, int scope, String primKey, String actionId) throws PortalException {
        this.resourcePermissionLocalService.removeResourcePermission(role.getCompanyId(), resourceName, scope, primKey, role.getRoleId(), actionId);
    }
}

