Liferay.Loader.define("remote-app-support-web@1.0.4/index", ['module', 'exports', 'require', 'frontend-js-web'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = init;
    exports.VERSION = exports.REMOTE_APP_PROTOCOL = void 0;

    var _frontendJsWeb = require("frontend-js-web");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    var APPS_TO_IDS = new Map();
    var APP_IDS = new Set();
    var ERROR_CODES = {
      /* eslint-disable sort-keys */
      UNKNOWN: -100,
      ALREADY_REGISTERED: -101
      /* eslint-enable sort-keys */

    };
    var REMOTE_APP_PROTOCOL = 'com.liferay.remote.app.protocol';
    exports.REMOTE_APP_PROTOCOL = REMOTE_APP_PROTOCOL;
    var VERSION = 0;
    exports.VERSION = VERSION;
    var RESPONSES = {};

    function escape(untrusted) {
      return untrusted.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&#39;');
    }

    function getNumber(object, property) {
      if (has(object, property) && typeof object[property] === 'number') {
        return object[property];
      }
    }

    function getString(object, property) {
      if (has(object, property) && typeof object[property] === 'string') {
        return object[property];
      }
    }

    function has(object, property) {
      return Object.prototype.hasOwnProperty.call(object, property);
    }

    var LOG_PREFIX = "[HOST: remote-app-support]";

    function warning(message) {}

    function postMessage(target, data) {
      target.postMessage(_objectSpread({}, data, {
        protocol: REMOTE_APP_PROTOCOL,
        role: 'host',
        version: VERSION
      }), '*');
    }

    function receiveMessage(event) {
      var data = event.data,
          source = event.source;

      if (data && getString(data, 'protocol') === REMOTE_APP_PROTOCOL && getString(data, 'role') === 'client' && getNumber(data, 'version') === 0) {
        var appID = getString(data, 'appID');

        if (APPS_TO_IDS.has(source) && APPS_TO_IDS.get(source) !== appID) {
          var message = "Attempted to use new UUID ".concat(appID, " with application that is already registered");
          warning(message);
          postMessage(source, {
            appID: appID,
            code: ERROR_CODES.ALREADY_REGISTERED,
            kind: 'error',
            message: message
          });
          return;
        }

        var command = getString(data, 'command');

        switch (command) {
          case 'fetch':
            {
              var requestID = data.requestID; // TODO: more validation here

              var resource = data.resource;
              var _init = data.init;
              (0, _frontendJsWeb.fetch)(resource, _init).then(function (response) {
                RESPONSES[requestID] = response;
                postMessage(source, {
                  appID: appID,
                  headers: Array.from(response.headers.entries()),
                  kind: 'fetch:resolve',
                  ok: response.ok,
                  redirected: response.redirected,
                  requestID: requestID,
                  status: response.status,
                  statusText: response.statusText,
                  type: response.type,
                  url: response.url
                });
              })["catch"](function (error) {
                postMessage(source, {
                  appID: appID,
                  error: error,
                  kind: 'fetch:reject',
                  requestID: requestID
                });
              });
            }
            break;

          case 'fetch:response:blob':
            {
              var _RESPONSES$_requestID;

              var _requestID = data.requestID;
              /* eslint-disable-next-line no-unused-expressions */

              (_RESPONSES$_requestID = RESPONSES[_requestID]) === null || _RESPONSES$_requestID === void 0 ? void 0 : _RESPONSES$_requestID.blob().then(function (blob) {
                postMessage(source, {
                  appID: appID,
                  blob: blob,
                  kind: 'fetch:response:blob:resolve',
                  requestID: _requestID
                });
              })["catch"](function (error) {
                postMessage(source, {
                  appID: appID,
                  error: error,
                  kind: 'fetch:response:blob:reject',
                  requestID: _requestID
                });
              });
            }
            break;

          case 'fetch:response:json':
            {
              var _RESPONSES$_requestID2;

              var _requestID2 = data.requestID;
              /* eslint-disable-next-line no-unused-expressions */

              (_RESPONSES$_requestID2 = RESPONSES[_requestID2]) === null || _RESPONSES$_requestID2 === void 0 ? void 0 : _RESPONSES$_requestID2.json().then(function (json) {
                postMessage(source, {
                  appID: appID,
                  json: json,
                  kind: 'fetch:response:json:resolve',
                  requestID: _requestID2
                });
              })["catch"](function (error) {
                postMessage(source, {
                  appID: appID,
                  error: error,
                  kind: 'fetch:response:json:reject',
                  requestID: _requestID2
                });
              });
            }
            break;

          case 'fetch:response:text':
            {
              var _RESPONSES$_requestID3;

              var _requestID3 = data.requestID;
              /* eslint-disable-next-line no-unused-expressions */

              (_RESPONSES$_requestID3 = RESPONSES[_requestID3]) === null || _RESPONSES$_requestID3 === void 0 ? void 0 : _RESPONSES$_requestID3.text().then(function (text) {
                postMessage(source, {
                  appID: appID,
                  kind: 'fetch:response:text:resolve',
                  requestID: _requestID3,
                  text: text
                });
              })["catch"](function (error) {
                postMessage(source, {
                  appID: appID,
                  error: error,
                  kind: 'fetch:response:text:reject',
                  requestID: _requestID3
                });
              });
            }
            break;

          case 'get':
            {
              var property = getString(data, 'property');
              var _requestID4 = data.requestID;
              var value;

              if (property === 'companyId') {
                value = Liferay.ThemeDisplay.getCompanyId();
              } else if (property === 'css') {
                value = Liferay.ThemeDisplay.getCDNBaseURL() + Liferay.ThemeDisplay.getPathThemeRoot() + '/css/clay.css';
              } else if (property === 'defaultLanguageId') {
                value = Liferay.ThemeDisplay.getDefaultLanguageId();
              } else if (property === 'isControlPanel') {
                // Note: likely to always be `false`, because we only
                // render remote apps in widgets on normal pages, for
                // now.
                value = Liferay.ThemeDisplay.isControlPanel();
              } else if (property === 'languageId') {
                value = Liferay.ThemeDisplay.getLanguageId();
              } else if (property === 'isSignedIn') {
                value = Liferay.ThemeDisplay.isSignedIn();
              } else if (property === 'userId') {
                value = Liferay.ThemeDisplay.getUserId();
              } else if (property === 'userName') {
                value = Liferay.ThemeDisplay.getUserName();
              }

              if (value !== undefined) {
                postMessage(source, {
                  appID: appID,
                  kind: 'get:resolve',
                  property: property,
                  requestID: _requestID4,
                  value: value
                });
              } else {
                postMessage(source, {
                  appID: appID,
                  error: "Unsupported property ".concat(property),
                  kind: 'get:reject',
                  property: property,
                  requestID: _requestID4
                });
              }
            }
            break;

          case 'navigate':
            {
              var url = getString(data, 'url');

              if (url) {
                (0, _frontendJsWeb.navigate)(url);
              }
            }
            break;

          case 'openToast':
            {
              var type = getString(data, 'type') || 'info';

              var _message = getString(data, 'message');

              if (_message) {
                // example of dealing with untrusted input
                (0, _frontendJsWeb.openToast)({
                  message: escape(_message),
                  type: escape(type)
                });
              }
            }
            break;

          case 'register':
            {
              var uuid = getString(data, 'appID');

              if (uuid) {
                if (APP_IDS.has(uuid)) {
                  var _message2 = "Attempted to register already registered UUID ".concat(uuid);

                  warning(_message2);
                } else {
                  APPS_TO_IDS.set(source, uuid);
                  APP_IDS.add(uuid);
                  postMessage(source, {
                    appID: uuid,
                    kind: 'registered'
                  });
                }
              }
            }
            break;

          case 'unregister':
            {
              if (APPS_TO_IDS.has(source) && APP_IDS.has(appID)) {
                APPS_TO_IDS["delete"](source);
                APP_IDS["delete"](appID);
              } else {
                warning('Unable to unregister invalid source/ID combination');
              }
            }
            break;

          default:
            warning("Unexpected command: ".concat(command));
            break;
        }
      }
    }

    function init() {
      window.addEventListener('message', receiveMessage);
    }
    //# sourceMappingURL=index.js.map
  }
});
//# sourceMappingURL=index.js.map