/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.registry.internal;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceReferenceMapper;
import com.liferay.registry.collections.ServiceTrackerMapListener;
import com.liferay.registry.internal.ServiceReferenceWrapper;
import com.liferay.registry.internal.ServiceTrackerCustomizerAdapter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;

public class ServiceTrackerMapFactoryImpl
implements com.liferay.registry.collections.ServiceTrackerMapFactory {
    private final BundleContext _bundleContext;
    private final ReferenceQueue<ServiceTrackerMap<?, ?>> _referenceQueue = new ReferenceQueue();
    private final Set<Reference<ServiceTrackerMap<?, ?>>> _serviceTrackerMaps = Collections.newSetFromMap(new ConcurrentHashMap());

    public ServiceTrackerMapFactoryImpl(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    public void clearServiceTrackerMaps() {
        Iterator<Reference<ServiceTrackerMap<?, ?>>> iterator = this._serviceTrackerMaps.iterator();
        while (iterator.hasNext()) {
            Reference<ServiceTrackerMap<?, ?>> serviceTrackerMapReference = iterator.next();
            iterator.remove();
            ServiceTrackerMap<?, ?> serviceTrackerMap = serviceTrackerMapReference.get();
            if (serviceTrackerMap == null) continue;
            try {
                serviceTrackerMap.close();
            }
            catch (Throwable throwable) {}
        }
        while (this._referenceQueue.poll() != null) {
        }
    }

    public <S> com.liferay.registry.collections.ServiceTrackerMap<String, List<S>> openMultiValueMap(Class<S> clazz, String propertyKey) {
        ServiceTrackerMap serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)this._bundleContext, clazz, (String)propertyKey);
        this.addServiceTrackerMap(serviceTrackerMap);
        return new ServiceTrackerMapWrapper<String, List<S>>(serviceTrackerMap);
    }

    public <K, S> com.liferay.registry.collections.ServiceTrackerMap<K, List<S>> openMultiValueMap(Class<S> clazz, String filterString, ServiceReferenceMapper<K, ? super S> serviceReferenceMapper) {
        ServiceReferenceMapperWrapper<K, ? super S> serviceReferenceMapperWrapper = new ServiceReferenceMapperWrapper<K, S>(serviceReferenceMapper);
        ServiceTrackerMap serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)this._bundleContext, clazz, (String)filterString, serviceReferenceMapperWrapper);
        this.addServiceTrackerMap(serviceTrackerMap);
        return new ServiceTrackerMapWrapper(serviceTrackerMap);
    }

    public <K, S> com.liferay.registry.collections.ServiceTrackerMap<K, List<S>> openMultiValueMap(Class<S> clazz, String filterString, ServiceReferenceMapper<K, ? super S> serviceReferenceMapper, Comparator<ServiceReference<S>> comparator) {
        ServiceReferenceMapperWrapper<K, ? super S> serviceReferenceMapperWrapper = new ServiceReferenceMapperWrapper<K, S>(serviceReferenceMapper);
        ServiceReferenceComparatorAdapter<S> serviceReferenceComparatorAdapter = new ServiceReferenceComparatorAdapter<S>(comparator);
        ServiceTrackerMap serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)this._bundleContext, clazz, (String)filterString, serviceReferenceMapperWrapper, serviceReferenceComparatorAdapter);
        this.addServiceTrackerMap(serviceTrackerMap);
        return new ServiceTrackerMapWrapper(serviceTrackerMap);
    }

    public <K, S> com.liferay.registry.collections.ServiceTrackerMap<K, List<S>> openMultiValueMap(Class<S> clazz, String filterString, ServiceReferenceMapper<K, ? super S> serviceReferenceMapper, ServiceTrackerMapListener<K, ? super S, List<S>> serviceTrackerMapListener) {
        ServiceReferenceMapperWrapper<K, ? super S> serviceReferenceMapperWrapper = new ServiceReferenceMapperWrapper<K, S>(serviceReferenceMapper);
        ServiceTrackerMapListenerWrapper<K, ? super S> serviceTrackerMapListenerWrapper = new ServiceTrackerMapListenerWrapper<K, S>(serviceTrackerMapListener);
        ServiceTrackerMap serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)this._bundleContext, clazz, (String)filterString, serviceReferenceMapperWrapper, serviceTrackerMapListenerWrapper);
        this.addServiceTrackerMap(serviceTrackerMap);
        return new ServiceTrackerMapWrapper(serviceTrackerMap);
    }

    public <K, SR, S> com.liferay.registry.collections.ServiceTrackerMap<K, List<S>> openMultiValueMap(Class<SR> clazz, String filterString, ServiceReferenceMapper<K, ? super SR> serviceReferenceMapper, ServiceTrackerCustomizer<SR, S> serviceTrackerCustomizer) {
        ServiceReferenceMapperWrapper<K, ? super SR> serviceReferenceMapperWrapper = new ServiceReferenceMapperWrapper<K, SR>(serviceReferenceMapper);
        ServiceTrackerCustomizerAdapter<SR, S> serviceTrackerCustomizerAdapter = new ServiceTrackerCustomizerAdapter<SR, S>(serviceTrackerCustomizer);
        ServiceTrackerMap serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)this._bundleContext, clazz, (String)filterString, serviceReferenceMapperWrapper, serviceTrackerCustomizerAdapter);
        this.addServiceTrackerMap(serviceTrackerMap);
        return new ServiceTrackerMapWrapper(serviceTrackerMap);
    }

    public <K, SR, S> com.liferay.registry.collections.ServiceTrackerMap<K, List<S>> openMultiValueMap(Class<SR> clazz, String filterString, ServiceReferenceMapper<K, ? super SR> serviceReferenceMapper, ServiceTrackerCustomizer<SR, S> serviceTrackerCustomizer, Comparator<ServiceReference<SR>> comparator) {
        ServiceReferenceMapperWrapper<K, ? super SR> serviceReferenceMapperWrapper = new ServiceReferenceMapperWrapper<K, SR>(serviceReferenceMapper);
        ServiceTrackerCustomizerAdapter<SR, S> serviceTrackerCustomizerAdapter = new ServiceTrackerCustomizerAdapter<SR, S>(serviceTrackerCustomizer);
        ServiceReferenceComparatorAdapter serviceReferenceComparatorAdapter = new ServiceReferenceComparatorAdapter(comparator);
        ServiceTrackerMap serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)this._bundleContext, clazz, (String)filterString, serviceReferenceMapperWrapper, serviceTrackerCustomizerAdapter, serviceReferenceComparatorAdapter);
        this.addServiceTrackerMap(serviceTrackerMap);
        return new ServiceTrackerMapWrapper(serviceTrackerMap);
    }

    public <SR, S> com.liferay.registry.collections.ServiceTrackerMap<String, List<S>> openMultiValueMap(Class<SR> clazz, String propertyKey, ServiceTrackerCustomizer<SR, S> serviceTrackerCustomizer) {
        ServiceTrackerCustomizerAdapter<SR, S> serviceTrackerCustomizerAdapter = new ServiceTrackerCustomizerAdapter<SR, S>(serviceTrackerCustomizer);
        ServiceTrackerMap serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)this._bundleContext, clazz, (String)propertyKey, serviceTrackerCustomizerAdapter);
        this.addServiceTrackerMap(serviceTrackerMap);
        return new ServiceTrackerMapWrapper<String, List<S>>(serviceTrackerMap);
    }

    public <S> com.liferay.registry.collections.ServiceTrackerMap<String, S> openSingleValueMap(Class<S> clazz, String propertyKey) {
        ServiceTrackerMap serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)this._bundleContext, clazz, (String)propertyKey);
        this.addServiceTrackerMap(serviceTrackerMap);
        return new ServiceTrackerMapWrapper(serviceTrackerMap);
    }

    public <K, S> com.liferay.registry.collections.ServiceTrackerMap<K, S> openSingleValueMap(Class<S> clazz, String filterString, ServiceReferenceMapper<K, ? super S> serviceReferenceMapper) {
        ServiceReferenceMapperWrapper<K, ? super S> serviceReferenceMapperWrapper = new ServiceReferenceMapperWrapper<K, S>(serviceReferenceMapper);
        ServiceTrackerMap serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)this._bundleContext, clazz, (String)filterString, serviceReferenceMapperWrapper);
        this.addServiceTrackerMap(serviceTrackerMap);
        return new ServiceTrackerMapWrapper(serviceTrackerMap);
    }

    public <K, S> com.liferay.registry.collections.ServiceTrackerMap<K, S> openSingleValueMap(Class<S> clazz, String filterString, ServiceReferenceMapper<K, ? super S> serviceReferenceMapper, Comparator<ServiceReference<S>> comparator) {
        ServiceReferenceMapperWrapper<K, ? super S> serviceReferenceMapperWrapper = new ServiceReferenceMapperWrapper<K, S>(serviceReferenceMapper);
        ServiceReferenceComparatorAdapter<S> serviceReferenceComparatorAdapter = new ServiceReferenceComparatorAdapter<S>(comparator);
        ServiceTrackerMap serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)this._bundleContext, clazz, (String)filterString, serviceReferenceMapperWrapper, serviceReferenceComparatorAdapter);
        this.addServiceTrackerMap(serviceTrackerMap);
        return new ServiceTrackerMapWrapper(serviceTrackerMap);
    }

    public <K, SR, S> com.liferay.registry.collections.ServiceTrackerMap<K, S> openSingleValueMap(Class<SR> clazz, String filterString, ServiceReferenceMapper<K, ? super SR> serviceReferenceMapper, ServiceTrackerCustomizer<SR, S> serviceTrackerCustomizer) {
        ServiceReferenceMapperWrapper<K, ? super SR> serviceReferenceMapperWrapper = new ServiceReferenceMapperWrapper<K, SR>(serviceReferenceMapper);
        ServiceTrackerCustomizerAdapter<SR, S> serviceTrackerCustomizerAdapter = new ServiceTrackerCustomizerAdapter<SR, S>(serviceTrackerCustomizer);
        ServiceTrackerMap serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)this._bundleContext, clazz, (String)filterString, serviceReferenceMapperWrapper, serviceTrackerCustomizerAdapter);
        this.addServiceTrackerMap(serviceTrackerMap);
        return new ServiceTrackerMapWrapper(serviceTrackerMap);
    }

    public <K, SR, S> com.liferay.registry.collections.ServiceTrackerMap<K, S> openSingleValueMap(Class<SR> clazz, String filterString, ServiceReferenceMapper<K, ? super SR> serviceReferenceMapper, ServiceTrackerCustomizer<SR, S> serviceTrackerCustomizer, Comparator<ServiceReference<SR>> comparator) {
        ServiceReferenceMapperWrapper<K, ? super SR> serviceReferenceMapperWrapper = new ServiceReferenceMapperWrapper<K, SR>(serviceReferenceMapper);
        ServiceTrackerCustomizerAdapter<SR, S> serviceTrackerCustomizerAdapter = new ServiceTrackerCustomizerAdapter<SR, S>(serviceTrackerCustomizer);
        ServiceReferenceComparatorAdapter serviceReferenceComparatorAdapter = new ServiceReferenceComparatorAdapter(comparator);
        ServiceTrackerMap serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)this._bundleContext, clazz, (String)filterString, serviceReferenceMapperWrapper, serviceTrackerCustomizerAdapter, serviceReferenceComparatorAdapter);
        this.addServiceTrackerMap(serviceTrackerMap);
        return new ServiceTrackerMapWrapper(serviceTrackerMap);
    }

    public <SR, S> com.liferay.registry.collections.ServiceTrackerMap<String, S> openSingleValueMap(Class<SR> clazz, String propertyKey, ServiceTrackerCustomizer<SR, S> serviceTrackerCustomizer) {
        ServiceTrackerCustomizerAdapter<SR, S> serviceTrackerCustomizerAdapter = new ServiceTrackerCustomizerAdapter<SR, S>(serviceTrackerCustomizer);
        ServiceTrackerMap serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)this._bundleContext, clazz, (String)propertyKey, serviceTrackerCustomizerAdapter);
        this.addServiceTrackerMap(serviceTrackerMap);
        return new ServiceTrackerMapWrapper(serviceTrackerMap);
    }

    protected void addServiceTrackerMap(ServiceTrackerMap<?, ?> serviceTrackerMap) {
        Reference reference = new WeakReference(serviceTrackerMap, this._referenceQueue);
        this._serviceTrackerMaps.add(reference);
        while ((reference = this._referenceQueue.poll()) != null) {
            this._serviceTrackerMaps.remove(reference);
        }
        return;
    }

    private static class ServiceTrackerMapWrapper<K, S>
    implements com.liferay.registry.collections.ServiceTrackerMap<K, S> {
        private final ServiceTrackerMap<K, S> _serviceTrackerMap;

        public ServiceTrackerMapWrapper(ServiceTrackerMap<K, S> serviceTrackerMap) {
            this._serviceTrackerMap = serviceTrackerMap;
        }

        public void close() {
            this._serviceTrackerMap.close();
        }

        public boolean containsKey(K k) {
            return this._serviceTrackerMap.containsKey(k);
        }

        public S getService(K k) {
            return (S)this._serviceTrackerMap.getService(k);
        }

        public Set<K> keySet() {
            return this._serviceTrackerMap.keySet();
        }
    }

    private static class ServiceTrackerMapListenerWrapper<K, S>
    implements com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapListener<K, S, List<S>> {
        private final ServiceTrackerMapListener<K, ? super S, List<S>> _serviceTrackerMapListener;

        public ServiceTrackerMapListenerWrapper(ServiceTrackerMapListener<K, ? super S, List<S>> serviceTrackerMapListener) {
            this._serviceTrackerMapListener = serviceTrackerMapListener;
        }

        public void keyEmitted(ServiceTrackerMap<K, List<S>> serviceTrackerMap, K key, S service, List<S> content) {
            this._serviceTrackerMapListener.keyEmitted(new ServiceTrackerMapWrapper<K, List<S>>(serviceTrackerMap), key, service, content);
        }

        public void keyRemoved(ServiceTrackerMap<K, List<S>> serviceTrackerMap, K key, S service, List<S> content) {
            this._serviceTrackerMapListener.keyRemoved(new ServiceTrackerMapWrapper<K, List<S>>(serviceTrackerMap), key, service, content);
        }
    }

    private static class ServiceReferenceMapperWrapper<K, S>
    implements com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper<K, S> {
        private final ServiceReferenceMapper<K, ? super S> _serviceReferenceMapper;

        public ServiceReferenceMapperWrapper(ServiceReferenceMapper<K, ? super S> serviceReferenceMapper) {
            this._serviceReferenceMapper = serviceReferenceMapper;
        }

        public void map(org.osgi.framework.ServiceReference<S> serviceReference, ServiceReferenceMapper.Emitter<K> emitter) {
            ServiceReferenceWrapper<S> serviceReferenceWrapper = new ServiceReferenceWrapper<S>(serviceReference);
            this._serviceReferenceMapper.map(serviceReferenceWrapper, new EmitterWrapper<K>(emitter));
        }
    }

    private static class ServiceReferenceComparatorAdapter<S>
    implements Comparator<org.osgi.framework.ServiceReference<S>> {
        private final Comparator<ServiceReference<S>> _comparator;

        public ServiceReferenceComparatorAdapter(Comparator<ServiceReference<S>> comparator) {
            this._comparator = comparator;
        }

        @Override
        public int compare(org.osgi.framework.ServiceReference<S> serviceReference1, org.osgi.framework.ServiceReference<S> serviceReference2) {
            return this._comparator.compare(new ServiceReferenceWrapper<S>(serviceReference1), new ServiceReferenceWrapper<S>(serviceReference2));
        }
    }

    private static class EmitterWrapper<K>
    implements ServiceReferenceMapper.Emitter<K> {
        private final ServiceReferenceMapper.Emitter<K> _emitter;

        public EmitterWrapper(ServiceReferenceMapper.Emitter<K> emitter) {
            this._emitter = emitter;
        }

        public void emit(K key) {
            this._emitter.emit(key);
        }
    }
}

