/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.registry.internal;

import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.internal.ServiceReferenceWrapper;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ServiceTrackerWrapper<S, T>
implements ServiceTracker<S, T> {
    private final org.osgi.util.tracker.ServiceTracker<S, T> _serviceTracker;

    public ServiceTrackerWrapper(org.osgi.util.tracker.ServiceTracker<S, T> serviceTracker) {
        this._serviceTracker = serviceTracker;
    }

    public T addingService(ServiceReference<S> serviceReference) {
        org.osgi.framework.ServiceReference<S> osgiServiceReference = this.getServiceReference(serviceReference);
        return (T)this._serviceTracker.addingService(osgiServiceReference);
    }

    public void close() {
        this._serviceTracker.close();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ServiceTrackerWrapper)) {
            return false;
        }
        ServiceTrackerWrapper serviceReferenceWrapper = (ServiceTrackerWrapper)object;
        return this._serviceTracker.equals(serviceReferenceWrapper.getServiceTracker());
    }

    public T getService() {
        return (T)this._serviceTracker.getService();
    }

    public T getService(ServiceReference<S> serviceReference) {
        org.osgi.framework.ServiceReference<S> osgiServiceReference = this.getServiceReference(serviceReference);
        return (T)this._serviceTracker.getService(osgiServiceReference);
    }

    public ServiceReference<S> getServiceReference() {
        return new ServiceReferenceWrapper(this._serviceTracker.getServiceReference());
    }

    public org.osgi.framework.ServiceReference<S> getServiceReference(ServiceReference<S> serviceReference) {
        if (!(serviceReference instanceof ServiceReferenceWrapper)) {
            throw new IllegalArgumentException();
        }
        ServiceReferenceWrapper serviceReferenceWrapper = (ServiceReferenceWrapper)serviceReference;
        return serviceReferenceWrapper.getServiceReference();
    }

    public ServiceReference<S>[] getServiceReferences() {
        org.osgi.framework.ServiceReference[] osgiServiceReferences = this._serviceTracker.getServiceReferences();
        if (osgiServiceReferences == null) {
            return null;
        }
        ServiceReference[] serviceReferences = new ServiceReference[osgiServiceReferences.length];
        for (int i = 0; i < osgiServiceReferences.length; ++i) {
            org.osgi.framework.ServiceReference osgiServiceReference = osgiServiceReferences[i];
            serviceReferences[i] = new ServiceReferenceWrapper(osgiServiceReference);
        }
        return serviceReferences;
    }

    public Object[] getServices() {
        return this._serviceTracker.getServices();
    }

    public T[] getServices(T[] services) {
        return this._serviceTracker.getServices((Object[])services);
    }

    public org.osgi.util.tracker.ServiceTracker<S, T> getServiceTracker() {
        return this._serviceTracker;
    }

    public SortedMap<ServiceReference<S>, T> getTrackedServiceReferences() {
        TreeMap trackedServiceReferences = new TreeMap(Collections.reverseOrder());
        SortedMap trackedOSGiServiceReferences = this._serviceTracker.getTracked();
        for (Map.Entry entry : trackedOSGiServiceReferences.entrySet()) {
            org.osgi.framework.ServiceReference osgiServiceReference = (org.osgi.framework.ServiceReference)entry.getKey();
            Object service = entry.getValue();
            ServiceReferenceWrapper serviceReferenceWrapper = new ServiceReferenceWrapper(osgiServiceReference);
            trackedServiceReferences.put(serviceReferenceWrapper, service);
        }
        return trackedServiceReferences;
    }

    public int getUpdateMarker() {
        return this._serviceTracker.getTrackingCount();
    }

    public int hashCode() {
        return this._serviceTracker.hashCode();
    }

    public boolean isEmpty() {
        return this._serviceTracker.isEmpty();
    }

    public void modifiedService(ServiceReference<S> serviceReference, T service) {
        org.osgi.framework.ServiceReference<S> osgiServiceReference = this.getServiceReference(serviceReference);
        this._serviceTracker.modifiedService(osgiServiceReference, service);
    }

    public void open() {
        this._serviceTracker.open();
    }

    public void open(boolean trackAllServices) {
        this._serviceTracker.open(trackAllServices);
    }

    public void remove(ServiceReference<S> serviceReference) {
        org.osgi.framework.ServiceReference<S> osgiServiceReference = this.getServiceReference(serviceReference);
        this._serviceTracker.remove(osgiServiceReference);
    }

    public void removedService(ServiceReference<S> serviceReference, T service) {
        org.osgi.framework.ServiceReference<S> osgiServiceReference = this.getServiceReference(serviceReference);
        this._serviceTracker.removedService(osgiServiceReference, service);
    }

    public int size() {
        return this._serviceTracker.size();
    }

    public String toString() {
        return this._serviceTracker.toString();
    }

    public T waitForService(long timeout) throws InterruptedException {
        return (T)this._serviceTracker.waitForService(timeout);
    }
}

