/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.registry.collections;

import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.collections.ServiceMapper;
import com.liferay.registry.collections.ServiceReferenceMapper;

public class ServiceReferenceMapperFactory {
    public static <K, S> ServiceReferenceMapper<K, S> create(final ServiceMapper<K, S> serviceMapper) {
        return new ServiceReferenceMapper<K, S>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void map(ServiceReference<S> serviceReference, ServiceReferenceMapper.Emitter<K> emitter) {
                Registry registry = RegistryUtil.getRegistry();
                Object service = registry.getService(serviceReference);
                try {
                    serviceMapper.map(service, emitter);
                }
                finally {
                    registry.ungetService(serviceReference);
                }
            }
        };
    }

    public static <K, S> ServiceReferenceMapper<K, S> create(final String propertyKey) {
        return new ServiceReferenceMapper<K, S>(){

            @Override
            public void map(ServiceReference<S> serviceReference, ServiceReferenceMapper.Emitter<K> emitter) {
                Object propertyValue = serviceReference.getProperty(propertyKey);
                if (propertyValue == null) {
                    return;
                }
                if (propertyValue instanceof Object[]) {
                    for (Object k : (Object[])propertyValue) {
                        emitter.emit(k);
                    }
                } else {
                    emitter.emit(propertyValue);
                }
            }
        };
    }
}

