/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.push.notifications.sender.sms.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.push.notifications.exception.PushNotificationsException;
import com.liferay.push.notifications.sender.PushNotificationsSender;
import com.liferay.push.notifications.sender.sms.internal.SMSResponse;
import com.liferay.push.notifications.sender.sms.internal.configuration.SMSPushNotificationsSenderConfiguration;
import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.resource.factory.SmsFactory;
import com.twilio.sdk.resource.instance.Account;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.push.notifications.sender.sms.internal.configuration.SMSPushNotificationsSenderConfiguration"}, immediate=true, property={"platform=sms"})
public class SMSPushNotificationsSender
implements PushNotificationsSender {
    public static final String PLATFORM = "sms";
    private volatile SMSPushNotificationsSenderConfiguration _smsPushNotificationsSenderConfiguration;
    private volatile TwilioRestClient _twilioRestClient;

    public void send(List<String> numbers, JSONObject payloadJSONObject) throws Exception {
        if (this._twilioRestClient == null) {
            throw new PushNotificationsException("SMS push notifications sender is not configured properly");
        }
        Account account = this._twilioRestClient.getAccount();
        SmsFactory smsFactory = account.getSmsFactory();
        String body = payloadJSONObject.getString("body");
        String from = payloadJSONObject.getString("from");
        if (Validator.isNull((String)from)) {
            from = this._smsPushNotificationsSenderConfiguration.number();
        }
        for (String number : numbers) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("Body", body);
            params.put("From", from);
            String statusCallback = this._smsPushNotificationsSenderConfiguration.statusCallback();
            if (Validator.isNotNull((String)statusCallback)) {
                params.put("StatusCallback", statusCallback);
            }
            params.put("To", number);
            SMSResponse response = new SMSResponse(smsFactory.create(params), payloadJSONObject);
            MessageBusUtil.sendMessage((String)"liferay/push_notification_response", (Object)((Object)response));
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._smsPushNotificationsSenderConfiguration = (SMSPushNotificationsSenderConfiguration)ConfigurableUtil.createConfigurable(SMSPushNotificationsSenderConfiguration.class, properties);
        String accountSID = this._smsPushNotificationsSenderConfiguration.accountSID();
        String authToken = this._smsPushNotificationsSenderConfiguration.authToken();
        if (Validator.isNull((String)accountSID) || Validator.isNull((String)authToken)) {
            this._twilioRestClient = null;
            return;
        }
        this._twilioRestClient = new TwilioRestClient(accountSID, authToken);
    }
}

