/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.push.notifications.sender.firebase.internal;

import com.liferay.mobile.fcm.Message;
import com.liferay.mobile.fcm.Notification;
import com.liferay.mobile.fcm.Sender;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.push.notifications.exception.PushNotificationsException;
import com.liferay.push.notifications.sender.PushNotificationsSender;
import com.liferay.push.notifications.sender.firebase.internal.configuration.FirebasePushNotificationsSenderConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.push.notifications.sender.firebase.internal.configuration.FirebasePushNotificationsSenderConfiguration"}, immediate=true, property={"platform=firebase"}, service={PushNotificationsSender.class})
public class FirebasePushNotificationsSender
implements PushNotificationsSender {
    public static final String PLATFORM = "firebase";
    private volatile FirebasePushNotificationsSenderConfiguration _firebasePushNotificationsSenderConfiguration;
    private volatile Sender _sender;

    public void send(List<String> tokens, JSONObject payloadJSONObject) throws Exception {
        if (this._sender == null) {
            throw new PushNotificationsException("Firebase push notifications sender is not configured properly");
        }
        this._sender.send(this.buildMessage(tokens, payloadJSONObject));
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._firebasePushNotificationsSenderConfiguration = (FirebasePushNotificationsSenderConfiguration)ConfigurableUtil.createConfigurable(FirebasePushNotificationsSenderConfiguration.class, properties);
        String apiKey = this._firebasePushNotificationsSenderConfiguration.apiKey();
        if (Validator.isNull((String)apiKey)) {
            this._sender = null;
            return;
        }
        this._sender = new Sender(apiKey);
    }

    protected Message buildMessage(List<String> tokens, JSONObject payloadJSONObject) {
        Message.Builder builder = new Message.Builder();
        boolean silent = payloadJSONObject.getBoolean("silent");
        if (silent) {
            builder.contentAvailable(silent);
        }
        builder.notification(this.buildNotification(payloadJSONObject));
        builder.to(tokens);
        JSONObject newPayloadJSONObject = JSONFactoryUtil.createJSONObject();
        Iterator iterator = payloadJSONObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (key.equals("badge") || key.equals("body") || key.equals("bodyLocalizedKey") || key.equals("bodyLocalizedArguments") || key.equals("sound") || key.equals("silent")) continue;
            newPayloadJSONObject.put(key, payloadJSONObject.get(key));
        }
        if (newPayloadJSONObject.length() > 0) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("payload", newPayloadJSONObject.toString());
            builder.data(data);
        }
        return builder.build();
    }

    protected Notification buildNotification(JSONObject payloadJSONObject) {
        String titleLocalizedKey;
        JSONArray titleLocalizedArgumentsJSONArray;
        String title;
        String sound;
        JSONArray bodyLocalizedArgumentsJSONArray;
        String bodyLocalizedKey;
        String body;
        Notification.Builder builder = new Notification.Builder();
        if (payloadJSONObject.has("badge")) {
            builder.badge(payloadJSONObject.getInt("badge"));
        }
        if (Validator.isNotNull((String)(body = payloadJSONObject.getString("body")))) {
            builder.body(body);
        }
        if (Validator.isNotNull((String)(bodyLocalizedKey = payloadJSONObject.getString("bodyLocalizedKey")))) {
            builder.bodyLocalizationKey(bodyLocalizedKey);
        }
        if ((bodyLocalizedArgumentsJSONArray = payloadJSONObject.getJSONArray("bodyLocalizedArguments")) != null) {
            ArrayList<String> bodyLocalizedArguments = new ArrayList<String>();
            for (int i = 0; i < bodyLocalizedArgumentsJSONArray.length(); ++i) {
                bodyLocalizedArguments.add(bodyLocalizedArgumentsJSONArray.getString(i));
            }
            builder.bodyLocalizationArguments(bodyLocalizedArguments);
        }
        if (Validator.isNotNull((String)(sound = payloadJSONObject.getString("sound")))) {
            builder.sound(sound);
        }
        if (Validator.isNotNull((String)(title = payloadJSONObject.getString("title")))) {
            builder.title(title);
        }
        if ((titleLocalizedArgumentsJSONArray = payloadJSONObject.getJSONArray("titleLocalizedArguments")) != null) {
            ArrayList<String> localizedArguments = new ArrayList<String>();
            for (int i = 0; i < titleLocalizedArgumentsJSONArray.length(); ++i) {
                localizedArguments.add(titleLocalizedArgumentsJSONArray.getString(i));
            }
            builder.titleLocalizationArguments(localizedArguments);
        }
        if (Validator.isNotNull((String)(titleLocalizedKey = payloadJSONObject.getString("titleLocalizedKey")))) {
            builder.titleLocalizationKey(titleLocalizedKey);
        }
        return builder.build();
    }

    @Deactivate
    protected void deactivate() {
        this._sender = null;
    }
}

