/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.product.navigation.personal.menu;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.product.navigation.personal.menu.PersonalMenuEntry;
import com.liferay.product.navigation.personal.menu.util.PersonalApplicationURLUtil;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public abstract class BasePersonalMenuEntry
implements PersonalMenuEntry {
    @Override
    public String getLabel(Locale locale) {
        return LanguageUtil.get((ResourceBundle)this.getResourceBundle(locale), (String)("javax.portlet.title." + this.getPortletId()));
    }

    public abstract String getPortletId();

    @Override
    public String getPortletURL(HttpServletRequest httpServletRequest) throws PortalException {
        if (Validator.isNull((String)this.getPortletId())) {
            return null;
        }
        return PersonalApplicationURLUtil.getPersonalApplicationURL(httpServletRequest, this.getPortletId());
    }

    @Override
    public boolean isActive(PortletRequest portletRequest, String portletId) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        String layoutFriendlyURL = layout.getFriendlyURL();
        if (!layout.isTypeControlPanel() && !layout.isSystem() || !layoutFriendlyURL.equals(PropsUtil.get((String)"control.panel.layout.friendly.url"))) {
            return false;
        }
        return portletId.equals(this.getPortletId());
    }

    @Override
    public boolean isShow(PortletRequest portletRequest, PermissionChecker permissionChecker) throws PortalException {
        try {
            return this.hasAccessPermission(permissionChecker, PortletLocalServiceUtil.getPortletById((String)this.getPortletId()));
        }
        catch (PortalException | RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundleUtil.getBundle((Locale)locale, this.getClass());
    }

    protected boolean hasAccessPermission(PermissionChecker permissionChecker, Portlet portlet) throws Exception {
        List actions = ResourceActionsUtil.getResourceActions((String)portlet.getPortletId());
        return actions.contains("ACCESS_IN_CONTROL_PANEL") && PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (long)0L, (String)portlet.getRootPortletId(), (String)"ACCESS_IN_CONTROL_PANEL", (boolean)true);
    }
}

