/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.display.template.internal.exportimport.portlet.preferences.processor;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.display.template.PortletDisplayTemplate;
import com.liferay.portlet.display.template.exportimport.portlet.preferences.processor.PortletDisplayTemplateRegister;
import javax.portlet.PortletPreferences;

public class PortletDisplayTemplateExportCapability
implements Capability {
    private final Portal _portal;
    private final PortletDisplayTemplate _portletDisplayTemplate;
    private final PortletDisplayTemplateRegister _portletDisplayTemplateExportRegister;
    private final PortletLocalService _portletLocalService;

    public PortletDisplayTemplateExportCapability(Portal portal, PortletLocalService portletLocalService, PortletDisplayTemplate portletDisplayTemplate, PortletDisplayTemplateRegister portletDisplayTemplateExportRegister) {
        this._portal = portal;
        this._portletLocalService = portletLocalService;
        this._portletDisplayTemplate = portletDisplayTemplate;
        this._portletDisplayTemplateExportRegister = portletDisplayTemplateExportRegister;
    }

    public PortletPreferences process(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        this.exportDisplayStyle(portletDataContext, portletDataContext.getPortletId(), portletPreferences);
        return portletPreferences;
    }

    protected void exportDisplayStyle(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws PortletDataException {
        DDMTemplate ddmTemplate;
        String displayStyle = this._portletDisplayTemplateExportRegister.getDisplayStyle(portletDataContext, portletId, portletPreferences);
        if (Validator.isNull((String)displayStyle) || !displayStyle.startsWith("ddmTemplate_")) {
            return;
        }
        long displayStyleGroupId = this._portletDisplayTemplateExportRegister.getDisplayStyleGroupId(portletDataContext, portletId, portletPreferences);
        long previousScopeGroupId = portletDataContext.getScopeGroupId();
        if (displayStyleGroupId != portletDataContext.getScopeGroupId()) {
            portletDataContext.setScopeGroupId(displayStyleGroupId);
        }
        if ((ddmTemplate = this._portletDisplayTemplate.getPortletDisplayTemplateDDMTemplate(portletDataContext.getGroupId(), this.getClassNameId(portletDataContext, portletId), displayStyle, false)) != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)ddmTemplate);
        }
        portletDataContext.setScopeGroupId(previousScopeGroupId);
    }

    protected long getClassNameId(PortletDataContext portletDataContext, String portletId) {
        Portlet portlet = this._portletLocalService.getPortletById(portletDataContext.getCompanyId(), portletId);
        TemplateHandler templateHandler = portlet.getTemplateHandlerInstance();
        if (templateHandler == null) {
            return 0L;
        }
        String className = templateHandler.getClassName();
        return this._portal.getClassNameId(className);
    }
}

