/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.display.template.internal;

import com.liferay.dynamic.data.mapping.exception.NoSuchTemplateException;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.portletdisplaytemplate.BasePortletDisplayTemplateHandler;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.template.TemplateHandlerRegistryUtil;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateVariableGroup;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.templateparser.Transformer;
import com.liferay.portlet.display.template.PortletDisplayTemplate;
import com.liferay.taglib.servlet.PipingServletResponse;
import com.liferay.taglib.util.VelocityTaglib;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortletDisplayTemplate.class})
public class PortletDisplayTemplateImpl
implements PortletDisplayTemplate {
    private static final Log _log = LogFactoryUtil.getLog(PortletDisplayTemplateImpl.class);
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;

    public DDMTemplate fetchDDMTemplate(long groupId, String displayStyle) {
        block8: {
            try {
                String uuid = this.getDDMTemplateKey(displayStyle);
                if (Validator.isNull((String)uuid)) {
                    return null;
                }
                try {
                    return this._ddmTemplateLocalService.getDDMTemplateByUuidAndGroupId(uuid, groupId);
                }
                catch (PortalException pe) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)pe, (Throwable)pe);
                    }
                    Group group = this._groupLocalService.getGroup(groupId);
                    Group companyGroup = this._groupLocalService.getCompanyGroup(group.getCompanyId());
                    try {
                        return this._ddmTemplateLocalService.getDDMTemplateByUuidAndGroupId(uuid, companyGroup.getGroupId());
                    }
                    catch (NoSuchTemplateException noSuchTemplateException) {
                    }
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    public long getDDMTemplateGroupId(long groupId) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return groupId;
        }
        try {
            Group liveGroup;
            if (group.isLayout()) {
                group = group.getParentGroup();
            }
            if (group.isStagingGroup() && !(liveGroup = group.getLiveGroup()).isStagedPortlet("com_liferay_dynamic_data_mapping_web_portlet_PortletDisplayTemplatePortlet")) {
                return liveGroup.getGroupId();
            }
            return group.getGroupId();
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            return groupId;
        }
    }

    public String getDDMTemplateKey(String displayStyle) {
        if (!displayStyle.startsWith("ddmTemplate_")) {
            return null;
        }
        return displayStyle.substring("ddmTemplate_".length());
    }

    @Deprecated
    public String getDDMTemplateUuid(String displayStyle) {
        return this.getDDMTemplateKey(displayStyle);
    }

    public DDMTemplate getDefaultPortletDisplayTemplateDDMTemplate(long groupId, long classNameId) {
        TemplateHandler templateHandler = TemplateHandlerRegistryUtil.getTemplateHandler((long)classNameId);
        if (templateHandler == null || templateHandler.getDefaultTemplateKey() == null) {
            return null;
        }
        return this.getPortletDisplayTemplateDDMTemplate(groupId, classNameId, this.getDisplayStyle(templateHandler.getDefaultTemplateKey()));
    }

    public String getDisplayStyle(String ddmTemplateKey) {
        return "ddmTemplate_" + ddmTemplateKey;
    }

    public DDMTemplate getPortletDisplayTemplateDDMTemplate(long groupId, long classNameId, String displayStyle) {
        return this.getPortletDisplayTemplateDDMTemplate(groupId, classNameId, displayStyle, false);
    }

    public DDMTemplate getPortletDisplayTemplateDDMTemplate(long groupId, long classNameId, String displayStyle, boolean useDefault) {
        String ddmTemplateKey;
        DDMTemplate portletDisplayDDMTemplate = null;
        if (displayStyle.startsWith("ddmTemplate_") && Validator.isNotNull((String)(ddmTemplateKey = this.getDDMTemplateKey(displayStyle)))) {
            portletDisplayDDMTemplate = this._ddmTemplateLocalService.fetchTemplate(this.getDDMTemplateGroupId(groupId), classNameId, ddmTemplateKey, true);
        }
        if (portletDisplayDDMTemplate == null && useDefault) {
            portletDisplayDDMTemplate = this.getDefaultPortletDisplayTemplateDDMTemplate(groupId, classNameId);
        }
        return portletDisplayDDMTemplate;
    }

    @Deprecated
    public long getPortletDisplayTemplateDDMTemplateId(long groupId, String displayStyle) {
        DDMTemplate portletDisplayDDMTemplate;
        long portletDisplayDDMTemplateId = 0L;
        if (displayStyle.startsWith("ddmTemplate_") && (portletDisplayDDMTemplate = this.fetchDDMTemplate(this.getDDMTemplateGroupId(groupId), displayStyle)) != null) {
            portletDisplayDDMTemplateId = portletDisplayDDMTemplate.getTemplateId();
        }
        return portletDisplayDDMTemplateId;
    }

    public List<TemplateHandler> getPortletDisplayTemplateHandlers() {
        List templateHandlers = TemplateHandlerRegistryUtil.getTemplateHandlers();
        ArrayList<TemplateHandler> portletDisplayTemplateHandlers = new ArrayList<TemplateHandler>();
        for (TemplateHandler templateHandler : templateHandlers) {
            ClassLoaderBeanHandler classLoaderBeanHandler;
            Object bean;
            InvocationHandler invocationHandler;
            if (templateHandler instanceof BasePortletDisplayTemplateHandler) {
                portletDisplayTemplateHandlers.add(templateHandler);
                continue;
            }
            if (!ProxyUtil.isProxyClass(templateHandler.getClass()) || !((invocationHandler = ProxyUtil.getInvocationHandler((Object)templateHandler)) instanceof ClassLoaderBeanHandler) || !((bean = (classLoaderBeanHandler = (ClassLoaderBeanHandler)invocationHandler).getBean()) instanceof BasePortletDisplayTemplateHandler)) continue;
            portletDisplayTemplateHandlers.add(templateHandler);
        }
        return portletDisplayTemplateHandlers;
    }

    public Map<String, TemplateVariableGroup> getTemplateVariableGroups(String language) {
        LinkedHashMap<String, TemplateVariableGroup> templateVariableGroups = new LinkedHashMap<String, TemplateVariableGroup>();
        TemplateVariableGroup fieldsTemplateVariableGroup = new TemplateVariableGroup("fields");
        fieldsTemplateVariableGroup.addCollectionVariable("entries", List.class, "entries", "entries-item", null, "curEntry", null);
        fieldsTemplateVariableGroup.addVariable("entry", null, "entry");
        templateVariableGroups.put("fields", fieldsTemplateVariableGroup);
        TemplateVariableGroup generalVariablesTemplateVariableGroup = new TemplateVariableGroup("general-variables");
        generalVariablesTemplateVariableGroup.addVariable("current-url", String.class, "currentURL");
        generalVariablesTemplateVariableGroup.addVariable("locale", Locale.class, "locale");
        generalVariablesTemplateVariableGroup.addVariable("portlet-preferences", Map.class, "portletPreferences");
        generalVariablesTemplateVariableGroup.addVariable("template-id", null, "template_id");
        generalVariablesTemplateVariableGroup.addVariable("theme-display", ThemeDisplay.class, "themeDisplay");
        templateVariableGroups.put("general-variables", generalVariablesTemplateVariableGroup);
        TemplateVariableGroup utilTemplateVariableGroup = new TemplateVariableGroup("util");
        utilTemplateVariableGroup.addVariable("http-request", HttpServletRequest.class, "request");
        if (language.equals("vm")) {
            utilTemplateVariableGroup.addVariable("liferay-taglib", VelocityTaglib.class, "taglibLiferay");
        }
        utilTemplateVariableGroup.addVariable("render-request", RenderRequest.class, "renderRequest");
        utilTemplateVariableGroup.addVariable("render-response", RenderResponse.class, "renderResponse");
        templateVariableGroups.put("util", utilTemplateVariableGroup);
        return templateVariableGroups;
    }

    public String renderDDMTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, DDMTemplate ddmTemplate, List<?> entries) throws Exception {
        HashMap<String, Object> contextObjects = new HashMap<String, Object>();
        return this.renderDDMTemplate(httpServletRequest, httpServletResponse, ddmTemplate, entries, contextObjects);
    }

    public String renderDDMTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, DDMTemplate ddmTemplate, List<?> entries, Map<String, Object> contextObjects) throws Exception {
        Transformer transformer = TransformerHolder.getTransformer();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
        PortletResponse portletResponse = (PortletResponse)httpServletRequest.getAttribute("javax.portlet.response");
        if (portletRequest != null && portletResponse != null) {
            PortletURL currentURL = PortletURLUtil.getCurrent((LiferayPortletRequest)this._portal.getLiferayPortletRequest(portletRequest), (LiferayPortletResponse)this._portal.getLiferayPortletResponse(portletResponse));
            contextObjects.put("currentURL", currentURL.toString());
        }
        contextObjects.put("entries", entries);
        if (!entries.isEmpty()) {
            contextObjects.put("entry", entries.get(0));
        }
        contextObjects.put("locale", httpServletRequest.getLocale());
        if (portletRequest instanceof RenderRequest) {
            RenderRequest renderRequest = (RenderRequest)portletRequest;
            contextObjects.put("renderRequest", renderRequest);
        } else if (portletRequest instanceof ResourceRequest) {
            ResourceRequest resourceRequest = (ResourceRequest)portletRequest;
            contextObjects.put("resourceRequest", resourceRequest);
        }
        if (portletResponse instanceof RenderResponse) {
            RenderResponse renderResponse = (RenderResponse)portletResponse;
            contextObjects.put("renderResponse", renderResponse);
        } else if (portletResponse instanceof ResourceResponse) {
            ResourceResponse resourceResponse = (ResourceResponse)portletResponse;
            contextObjects.put("resourceResponse", resourceResponse);
        }
        contextObjects.put("template_id", ddmTemplate.getTemplateId());
        contextObjects.put("themeDisplay", themeDisplay);
        contextObjects.put("class_name_id", ddmTemplate.getClassNameId());
        TemplateManager templateManager = TemplateManagerUtil.getTemplateManager((String)ddmTemplate.getLanguage());
        TemplateHandler templateHandler = TemplateHandlerRegistryUtil.getTemplateHandler((long)ddmTemplate.getClassNameId());
        templateManager.addContextObjects(contextObjects, templateHandler.getCustomContextObjects());
        templateManager.addTaglibSupport(contextObjects, httpServletRequest, httpServletResponse);
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        templateManager.addTaglibTheme(contextObjects, "taglibLiferay", httpServletRequest, (HttpServletResponse)new PipingServletResponse(httpServletResponse, (Writer)unsyncStringWriter));
        contextObjects.put("writer", unsyncStringWriter);
        if (portletRequest != null) {
            this._mergePortletPreferences(portletRequest, contextObjects);
        }
        return transformer.transform(themeDisplay, contextObjects, ddmTemplate.getScript(), ddmTemplate.getLanguage(), unsyncStringWriter);
    }

    public String renderDDMTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long ddmTemplateId, List<?> entries) throws Exception {
        HashMap<String, Object> contextObjects = new HashMap<String, Object>();
        return this.renderDDMTemplate(httpServletRequest, httpServletResponse, ddmTemplateId, entries, contextObjects);
    }

    public String renderDDMTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long ddmTemplateId, List<?> entries, Map<String, Object> contextObjects) throws Exception {
        DDMTemplate ddmTemplate = this._ddmTemplateLocalService.getTemplate(ddmTemplateId);
        return this.renderDDMTemplate(httpServletRequest, httpServletResponse, ddmTemplate, entries, contextObjects);
    }

    private Map<String, Object> _mergePortletPreferences(PortletRequest portletRequest, Map<String, Object> contextObjects) {
        PortletPreferences portletPreferences = portletRequest.getPreferences();
        Map map = portletPreferences.getMap();
        contextObjects.put("portletPreferences", map);
        for (Map.Entry entry : map.entrySet()) {
            Object value;
            Object[] values;
            if (contextObjects.containsKey(entry.getKey()) || ArrayUtil.isEmpty((Object[])(values = (String[])entry.getValue())) || (value = values[0]) == null) continue;
            contextObjects.put((String)entry.getKey(), value);
        }
        return contextObjects;
    }

    private static class TransformerHolder {
        private static final Transformer _transformer = new Transformer("portlet.display.templates.error", true);

        private TransformerHolder() {
        }

        public static Transformer getTransformer() {
            return _transformer;
        }
    }
}

