/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.task.web.internal.permission;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskAssignee;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WorkflowTaskPermissionChecker {
    private static final Log _log = LogFactoryUtil.getLog(WorkflowTaskPermissionChecker.class);

    public boolean hasPermission(long groupId, WorkflowTask workflowTask, PermissionChecker permissionChecker) {
        if (permissionChecker.isOmniadmin() || permissionChecker.isCompanyAdmin() || workflowTask.isCompleted() && this.hasAssetViewPermission(workflowTask, permissionChecker)) {
            return true;
        }
        if (!this.hasAssetViewPermission(workflowTask, permissionChecker) && !permissionChecker.isContentReviewer(permissionChecker.getCompanyId(), groupId)) {
            return false;
        }
        long[] roleIds = this.getRoleIds(groupId, permissionChecker);
        for (WorkflowTaskAssignee workflowTaskAssignee : workflowTask.getWorkflowTaskAssignees()) {
            if (!this.isWorkflowTaskAssignableToRoles(workflowTaskAssignee, roleIds) && !this.isWorkflowTaskAssignableToUser(workflowTaskAssignee, permissionChecker.getUserId())) continue;
            return true;
        }
        return false;
    }

    protected List<Group> getAncestorGroups(Group group) throws PortalException {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Group ancestorGroup : group.getAncestors()) {
            groups.add(ancestorGroup);
        }
        return groups;
    }

    protected List<Group> getAncestorOrganizationGroups(Group group) throws PortalException {
        ArrayList<Group> groups = new ArrayList<Group>();
        Organization organization = OrganizationLocalServiceUtil.getOrganization((long)group.getClassPK());
        for (Organization ancestorOrganization : organization.getAncestors()) {
            groups.add(ancestorOrganization.getGroup());
        }
        return groups;
    }

    protected long[] getRoleIds(long groupId, PermissionChecker permissionChecker) {
        long[] roleIds = permissionChecker.getRoleIds(permissionChecker.getUserId(), groupId);
        try {
            ArrayList<Group> groups = new ArrayList<Group>();
            if (groupId != 0L) {
                Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                if (group.isOrganization()) {
                    groups.addAll(this.getAncestorOrganizationGroups(group));
                }
                if (group.isSite()) {
                    groups.addAll(this.getAncestorGroups(group));
                }
            }
            for (Group group : groups) {
                long[] roleIdArray = permissionChecker.getRoleIds(permissionChecker.getUserId(), group.getGroupId());
                roleIds = ArrayUtil.append((long[][])new long[][]{roleIds, roleIdArray});
            }
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
        return roleIds;
    }

    protected boolean hasAssetViewPermission(WorkflowTask workflowTask, PermissionChecker permissionChecker) {
        Map optionalAttributes = workflowTask.getOptionalAttributes();
        String className = MapUtil.getString((Map)optionalAttributes, (String)"entryClassName");
        WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler((String)className);
        if (workflowHandler == null) {
            return false;
        }
        long classPK = MapUtil.getLong((Map)optionalAttributes, (String)"entryClassPK");
        try {
            AssetRenderer assetRenderer = workflowHandler.getAssetRenderer(classPK);
            return assetRenderer.hasViewPermission(permissionChecker);
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
            return false;
        }
    }

    protected boolean isWorkflowTaskAssignableToRoles(WorkflowTaskAssignee workflowTaskAssignee, long[] roleIds) {
        String assigneeClassName = workflowTaskAssignee.getAssigneeClassName();
        if (!assigneeClassName.equals(Role.class.getName())) {
            return false;
        }
        return ArrayUtil.contains((long[])roleIds, (long)workflowTaskAssignee.getAssigneeClassPK());
    }

    protected boolean isWorkflowTaskAssignableToUser(WorkflowTaskAssignee workflowTaskAssignee, long userId) {
        String assigneeClassName = workflowTaskAssignee.getAssigneeClassName();
        if (!assigneeClassName.equals(User.class.getName())) {
            return false;
        }
        return workflowTaskAssignee.getAssigneeClassPK() == userId;
    }
}

