/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.integration.internal.security.permission.resource;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.kernel.workflow.WorkflowDefinition"}, service={ModelResourcePermission.class})
public class WorkflowDefinitionModelResourcePermission
implements ModelResourcePermission<KaleoDefinition> {
    @Reference
    private KaleoDefinitionLocalService _kaleoDefinitionLocalService;
    @Reference(target="(resource.name=com.liferay.portal.workflow)")
    private PortletResourcePermission _portletResourcePermission;

    public void check(PermissionChecker permissionChecker, KaleoDefinition kaleoDefinition, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, kaleoDefinition, actionId)) {
            throw new PrincipalException.MustBeCompanyAdmin(permissionChecker.getUserId());
        }
    }

    public void check(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        this.check(permissionChecker, this._kaleoDefinitionLocalService.getKaleoDefinition(primaryKey), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, KaleoDefinition kaleoDefinition, String actionId) throws PortalException {
        return this._portletResourcePermission.contains(permissionChecker, kaleoDefinition.getGroupId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._kaleoDefinitionLocalService.getKaleoDefinition(primaryKey), actionId);
    }

    public String getModelName() {
        return KaleoDefinition.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

