/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.integration.internal.security.permission;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskAssignee;
import com.liferay.portal.workflow.security.permission.WorkflowTaskPermission;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={WorkflowTaskPermission.class})
public class WorkflowTaskPermissionImpl
implements WorkflowTaskPermission {
    private static final Log _log = LogFactoryUtil.getLog(WorkflowTaskPermissionImpl.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public void check(PermissionChecker permissionChecker, WorkflowTask workflowTask, long groupId) throws PortalException {
        if (!this.contains(permissionChecker, workflowTask, groupId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, WorkflowTask.class.getName(), workflowTask.getWorkflowTaskId(), new String[]{"VIEW"});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, WorkflowTask workflowTask, long groupId) {
        if (permissionChecker.isOmniadmin() || permissionChecker.isCompanyAdmin()) {
            return true;
        }
        int userNotificationEventsCount = this._userNotificationEventLocalService.getUserNotificationEventsCount(permissionChecker.getUserId(), "com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet", (Map)HashMapBuilder.put((Object)"workflowInstanceId", (Object)String.valueOf(workflowTask.getWorkflowInstanceId())).put((Object)"workflowTaskId", (Object)String.valueOf(workflowTask.getWorkflowTaskId())).build());
        if (this.hasAssetViewPermission(workflowTask, permissionChecker) && (userNotificationEventsCount > 0 || workflowTask.isCompleted() && workflowTask.getAssigneeUserId() == permissionChecker.getUserId())) {
            return true;
        }
        long[] roleIds = this.getRoleIds(groupId, permissionChecker);
        for (WorkflowTaskAssignee workflowTaskAssignee : workflowTask.getWorkflowTaskAssignees()) {
            if (!this._isWorkflowTaskAssignableToRoles(workflowTaskAssignee, roleIds) && !this._isWorkflowTaskAssignableToUser(workflowTaskAssignee, permissionChecker.getUserId())) continue;
            return true;
        }
        if (!this.hasAssetViewPermission(workflowTask, permissionChecker) && !permissionChecker.isContentReviewer(permissionChecker.getCompanyId(), groupId)) {
            return false;
        }
        return false;
    }

    protected long[] getRoleIds(long groupId, PermissionChecker permissionChecker) {
        long[] roleIds = permissionChecker.getRoleIds(permissionChecker.getUserId(), groupId);
        try {
            ArrayList<Group> groups = new ArrayList<Group>();
            if (groupId != 0L) {
                Group group = this._groupLocalService.getGroup(groupId);
                if (group.isOrganization()) {
                    groups.addAll(this._getAncestorOrganizationGroups(group));
                }
                if (group.isSite()) {
                    groups.addAll(this._getAncestorGroups(group));
                }
            }
            for (Group group : groups) {
                long[] roleIdArray = permissionChecker.getRoleIds(permissionChecker.getUserId(), group.getGroupId());
                roleIds = ArrayUtil.append((long[][])new long[][]{roleIds, roleIdArray});
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
        return roleIds;
    }

    protected boolean hasAssetViewPermission(WorkflowTask workflowTask, PermissionChecker permissionChecker) {
        Map optionalAttributes = workflowTask.getOptionalAttributes();
        String className = MapUtil.getString((Map)optionalAttributes, (String)"entryClassName");
        WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler((String)className);
        if (workflowHandler == null) {
            return false;
        }
        long classPK = MapUtil.getLong((Map)optionalAttributes, (String)"entryClassPK");
        try {
            AssetRenderer assetRenderer = workflowHandler.getAssetRenderer(classPK);
            if (assetRenderer == null) {
                return false;
            }
            return assetRenderer.hasViewPermission(permissionChecker);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return false;
        }
    }

    private List<Group> _getAncestorGroups(Group group) throws PortalException {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Group ancestorGroup : group.getAncestors()) {
            groups.add(ancestorGroup);
        }
        return groups;
    }

    private List<Group> _getAncestorOrganizationGroups(Group group) throws PortalException {
        ArrayList<Group> groups = new ArrayList<Group>();
        Organization organization = this._organizationLocalService.getOrganization(group.getOrganizationId());
        for (Organization ancestorOrganization : organization.getAncestors()) {
            groups.add(ancestorOrganization.getGroup());
        }
        return groups;
    }

    private boolean _isWorkflowTaskAssignableToRoles(WorkflowTaskAssignee workflowTaskAssignee, long[] roleIds) {
        String assigneeClassName = workflowTaskAssignee.getAssigneeClassName();
        if (!assigneeClassName.equals(Role.class.getName())) {
            return false;
        }
        return ArrayUtil.contains((long[])roleIds, (long)workflowTaskAssignee.getAssigneeClassPK());
    }

    private boolean _isWorkflowTaskAssignableToUser(WorkflowTaskAssignee workflowTaskAssignee, long userId) {
        String assigneeClassName = workflowTaskAssignee.getAssigneeClassName();
        if (!assigneeClassName.equals(User.class.getName())) {
            return false;
        }
        return workflowTaskAssignee.getAssigneeClassPK() == userId;
    }
}

