/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.integration.impl.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.uuid.PortalUUID;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionManager;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.comparator.WorkflowComparatorFactory;
import com.liferay.portal.workflow.kaleo.KaleoWorkflowModelConverter;
import com.liferay.portal.workflow.kaleo.definition.Definition;
import com.liferay.portal.workflow.kaleo.definition.parser.WorkflowModelParser;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.runtime.WorkflowEngine;
import com.liferay.portal.workflow.kaleo.runtime.util.comparator.KaleoDefinitionOrderByComparator;
import com.liferay.portal.workflow.kaleo.runtime.util.comparator.KaleoDefinitionVersionOrderByComparator;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionVersionLocalService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"proxy.bean=false"}, service={WorkflowDefinitionManager.class})
public class WorkflowDefinitionManagerImpl
implements WorkflowDefinitionManager {
    @Reference
    protected PortalUUID portalUUID;
    @Reference
    private KaleoDefinitionLocalService _kaleoDefinitionLocalService;
    @Reference
    private KaleoDefinitionVersionLocalService _kaleoDefinitionVersionLocalService;
    @Reference
    private KaleoWorkflowModelConverter _kaleoWorkflowModelConverter;
    @Reference
    private WorkflowComparatorFactory _workflowComparatorFactory;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile WorkflowEngine _workflowEngine;
    @Reference
    private WorkflowModelParser _workflowModelParser;

    @Deprecated
    public WorkflowDefinition deployWorkflowDefinition(long companyId, long userId, String title, byte[] bytes) throws WorkflowException {
        Definition definition = this._workflowModelParser.parse((InputStream)new UnsyncByteArrayInputStream(bytes));
        return this.deployWorkflowDefinition(companyId, userId, title, definition.getName(), bytes);
    }

    public WorkflowDefinition deployWorkflowDefinition(long companyId, long userId, String title, String name, byte[] bytes) throws WorkflowException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(companyId);
        serviceContext.setUserId(userId);
        return this._workflowEngine.deployWorkflowDefinition(title, name, (InputStream)new UnsyncByteArrayInputStream(bytes), serviceContext);
    }

    public int getActiveWorkflowDefinitionCount(long companyId) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            return this._kaleoDefinitionLocalService.getKaleoDefinitionsCount(true, serviceContext);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public int getActiveWorkflowDefinitionCount(long companyId, String name) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            return this._kaleoDefinitionLocalService.getKaleoDefinitionsCount(name, true, serviceContext);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public List<WorkflowDefinition> getActiveWorkflowDefinitions(long companyId, int start, int end, OrderByComparator<WorkflowDefinition> orderByComparator) throws WorkflowException {
        try {
            if (orderByComparator == null) {
                orderByComparator = this._workflowComparatorFactory.getDefinitionNameComparator(true);
            }
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            List kaleoDefinitions = this._kaleoDefinitionLocalService.getKaleoDefinitions(true, start, end, KaleoDefinitionOrderByComparator.getOrderByComparator((OrderByComparator)orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            int size = kaleoDefinitions.size();
            return this.toWorkflowDefinitions(kaleoDefinitions.toArray(new KaleoDefinition[size]));
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public List<WorkflowDefinition> getActiveWorkflowDefinitions(long companyId, String name, int start, int end, OrderByComparator<WorkflowDefinition> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            ArrayList<KaleoDefinition> kaleoDefinitions = new ArrayList<KaleoDefinition>();
            KaleoDefinition kaleoDefinition = this._kaleoDefinitionLocalService.getKaleoDefinition(name, serviceContext);
            if (kaleoDefinition.isActive()) {
                kaleoDefinitions.add(kaleoDefinition);
            }
            int size = kaleoDefinitions.size();
            return this.toWorkflowDefinitions(kaleoDefinitions.toArray(new KaleoDefinition[size]));
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    @Deprecated
    public WorkflowDefinition getLatestKaleoDefinition(long companyId, String name) throws WorkflowException {
        return this.getLatestWorkflowDefinition(companyId, name);
    }

    public WorkflowDefinition getLatestWorkflowDefinition(long companyId, String name) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            KaleoDefinition kaleoDefinition = this._kaleoDefinitionLocalService.getKaleoDefinition(name, serviceContext);
            return this._kaleoWorkflowModelConverter.toWorkflowDefinition(kaleoDefinition);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public List<WorkflowDefinition> getLatestWorkflowDefinitions(long companyId, int start, int end, OrderByComparator<WorkflowDefinition> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            List kaleoDefinitions = this._kaleoDefinitionLocalService.getKaleoDefinitions(start, end, KaleoDefinitionOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            int size = kaleoDefinitions.size();
            return this.toWorkflowDefinitions(kaleoDefinitions.toArray(new KaleoDefinition[size]));
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public WorkflowDefinition getWorkflowDefinition(long companyId, String name, int version) throws WorkflowException {
        try {
            KaleoDefinitionVersion kaleoDefinitionVersion = this._kaleoDefinitionVersionLocalService.getKaleoDefinitionVersion(companyId, name, this.getVersion(version));
            return this._kaleoWorkflowModelConverter.toWorkflowDefinition(kaleoDefinitionVersion);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public int getWorkflowDefinitionCount(long companyId) throws WorkflowException {
        try {
            return this._kaleoDefinitionVersionLocalService.getKaleoDefinitionVersionsCount(companyId);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public int getWorkflowDefinitionCount(long companyId, String name) throws WorkflowException {
        try {
            return this._kaleoDefinitionVersionLocalService.getKaleoDefinitionVersionsCount(companyId, name);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public List<WorkflowDefinition> getWorkflowDefinitions(long companyId, int start, int end, OrderByComparator<WorkflowDefinition> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            List kaleoDefinitionVersions = this._kaleoDefinitionVersionLocalService.getKaleoDefinitionVersions(companyId, start, end, KaleoDefinitionVersionOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter));
            int size = kaleoDefinitionVersions.size();
            return this.toWorkflowDefinitions(kaleoDefinitionVersions.toArray(new KaleoDefinitionVersion[size]));
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public List<WorkflowDefinition> getWorkflowDefinitions(long companyId, String name, int start, int end, OrderByComparator<WorkflowDefinition> orderByComparator) throws WorkflowException {
        try {
            List kaleoDefinitionVersions = this._kaleoDefinitionVersionLocalService.getKaleoDefinitionVersions(companyId, name);
            int size = kaleoDefinitionVersions.size();
            return this.toWorkflowDefinitions(kaleoDefinitionVersions.toArray(new KaleoDefinitionVersion[size]));
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public WorkflowDefinition saveWorkflowDefinition(long companyId, long userId, String title, String name, byte[] bytes) throws WorkflowException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(companyId);
        serviceContext.setUserId(userId);
        return this._workflowEngine.saveWorkflowDefinition(title, name, bytes, serviceContext);
    }

    public void undeployWorkflowDefinition(long companyId, long userId, String name, int version) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            this._workflowEngine.deleteWorkflowDefinition(name, version, serviceContext);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public WorkflowDefinition updateActive(long companyId, long userId, String name, int version, boolean active) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            if (active) {
                this._kaleoDefinitionLocalService.activateKaleoDefinition(name, version, serviceContext);
            } else {
                this._kaleoDefinitionLocalService.deactivateKaleoDefinition(name, version, serviceContext);
            }
            return this.getWorkflowDefinition(companyId, name, version);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public WorkflowDefinition updateTitle(long companyId, long userId, String name, int version, String title) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            KaleoDefinition kaleoDefinition = this._kaleoDefinitionLocalService.getKaleoDefinition(name, serviceContext);
            String content = kaleoDefinition.getContent();
            return this._workflowEngine.deployWorkflowDefinition(title, name, (InputStream)new UnsyncByteArrayInputStream(content.getBytes()), serviceContext);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public void validateWorkflowDefinition(byte[] bytes) throws WorkflowException {
        this._workflowEngine.validateWorkflowDefinition((InputStream)new UnsyncByteArrayInputStream(bytes));
    }

    protected String getNextVersion(String version) {
        int[] versionParts = StringUtil.split((String)version, (String)".", (int)0);
        versionParts[0] = versionParts[0] + 1;
        return String.valueOf(versionParts[0]);
    }

    protected String getVersion(int version) {
        return version + "." + 0;
    }

    protected List<WorkflowDefinition> toWorkflowDefinitions(KaleoDefinition[] kaleoDefinitions) {
        ArrayList<WorkflowDefinition> workflowDefinitions = new ArrayList<WorkflowDefinition>(kaleoDefinitions.length);
        for (KaleoDefinition kaleoDefinition : kaleoDefinitions) {
            WorkflowDefinition workflowDefinition = this._kaleoWorkflowModelConverter.toWorkflowDefinition(kaleoDefinition);
            workflowDefinitions.add(workflowDefinition);
        }
        return workflowDefinitions;
    }

    protected List<WorkflowDefinition> toWorkflowDefinitions(KaleoDefinitionVersion[] kaleoDefinitionVersions) throws PortalException {
        ArrayList<WorkflowDefinition> workflowDefinitions = new ArrayList<WorkflowDefinition>(kaleoDefinitionVersions.length);
        for (KaleoDefinitionVersion kaleoDefinitionVersion : kaleoDefinitionVersions) {
            WorkflowDefinition workflowDefinition = this._kaleoWorkflowModelConverter.toWorkflowDefinition(kaleoDefinitionVersion);
            workflowDefinitions.add(workflowDefinition);
        }
        return workflowDefinitions;
    }
}

