/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={KaleoWorkflowMessagingConfigurator.class})
public class KaleoWorkflowMessagingConfigurator {
    private static final int _MAXIMUM_QUEUE_SIZE = 200;
    private static final Log _log = LogFactoryUtil.getLog(KaleoWorkflowMessagingConfigurator.class);
    private BundleContext _bundleContext;
    @Reference
    private DestinationFactory _destinationFactory;
    private final List<ServiceRegistration<Destination>> _serviceRegistrations = new ArrayList<ServiceRegistration<Destination>>();

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._registerWorkflowDefinitionLinkDestination();
        this._registerWorkflowTimerDestination();
    }

    @Deactivate
    protected void deactivate() {
        for (ServiceRegistration<Destination> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    private void _registerDestination(DestinationConfiguration destinationConfiguration) {
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        this._serviceRegistrations.add((ServiceRegistration<Destination>)this._bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName())));
    }

    private void _registerWorkflowDefinitionLinkDestination() {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("synchronous", "destination.workflow_definition_link");
        this._registerDestination(destinationConfiguration);
    }

    private void _registerWorkflowTimerDestination() {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("parallel", "destination.workflow_timer");
        destinationConfiguration.setMaximumQueueSize(200);
        ThreadPoolExecutor.CallerRunsPolicy rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy(){

            @Override
            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"The current thread will handle the request because the workflow timer task queue is at its maximum capacity");
                }
                super.rejectedExecution(runnable, threadPoolExecutor);
            }
        };
        destinationConfiguration.setRejectedExecutionHandler((RejectedExecutionHandler)rejectedExecutionHandler);
        this._registerDestination(destinationConfiguration);
    }
}

