/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.helper;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapperFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.workflow.kaleo.definition.ExecutionType;
import com.liferay.portal.workflow.kaleo.model.KaleoNotification;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationHelper;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationMessageGenerator;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationSender;
import com.liferay.portal.workflow.kaleo.service.KaleoNotificationLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoNotificationRecipientLocalService;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={NotificationHelper.class})
public class NotificationHelperImpl
implements NotificationHelper {
    @Reference
    private KaleoNotificationLocalService _kaleoNotificationLocalService;
    @Reference
    private KaleoNotificationRecipientLocalService _kaleoNotificationRecipientLocalService;
    private ServiceTrackerMap<String, NotificationMessageGenerator> _notificationMessageGeneratorServiceTrackerMap;
    private ServiceTrackerMap<String, NotificationSender> _notificationSenderServiceTrackerMap;

    public void sendKaleoNotifications(String kaleoClassName, long kaleoClassPK, ExecutionType executionType, ExecutionContext executionContext) throws PortalException {
        List kaleoNotifications = this._kaleoNotificationLocalService.getKaleoNotifications(kaleoClassName, kaleoClassPK, executionType.getValue());
        for (KaleoNotification kaleoNotification : kaleoNotifications) {
            this._sendKaleoNotification(kaleoNotification, executionContext);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._notificationMessageGeneratorServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, NotificationMessageGenerator.class, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.create((BundleContext)bundleContext, (notificationMessageGenerator, emitter) -> {
            for (String templateLanguage : notificationMessageGenerator.getTemplateLanguages()) {
                emitter.emit((Object)templateLanguage);
            }
        }));
        this._notificationSenderServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, NotificationSender.class, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.create((BundleContext)bundleContext, (notificationSender, emitter) -> emitter.emit((Object)notificationSender.getNotificationType())));
    }

    @Deactivate
    protected void deactivate() {
        this._notificationMessageGeneratorServiceTrackerMap.close();
        this._notificationSenderServiceTrackerMap.close();
    }

    private void _sendKaleoNotification(KaleoNotification kaleoNotification, ExecutionContext executionContext) throws PortalException {
        NotificationMessageGenerator notificationMessageGenerator = (NotificationMessageGenerator)this._notificationMessageGeneratorServiceTrackerMap.getService((Object)kaleoNotification.getTemplateLanguage());
        if (notificationMessageGenerator == null) {
            throw new WorkflowException("Invalid template language " + kaleoNotification.getTemplateLanguage());
        }
        String notificationMessage = notificationMessageGenerator.generateMessage(kaleoNotification.getKaleoClassName(), kaleoNotification.getKaleoClassPK(), kaleoNotification.getName(), kaleoNotification.getTemplateLanguage(), kaleoNotification.getTemplate(), executionContext);
        String notificationSubject = "";
        if (Validator.isNotNull((String)kaleoNotification.getDescription())) {
            notificationSubject = notificationMessageGenerator.generateMessage(kaleoNotification.getKaleoClassName(), kaleoNotification.getKaleoClassPK(), kaleoNotification.getName(), kaleoNotification.getTemplateLanguage(), kaleoNotification.getDescription(), executionContext);
        }
        String[] notificationTypes = StringUtil.split((String)kaleoNotification.getNotificationTypes());
        List kaleoNotificationRecipient = this._kaleoNotificationRecipientLocalService.getKaleoNotificationRecipients(kaleoNotification.getKaleoNotificationId());
        for (String notificationType : notificationTypes) {
            NotificationSender notificationSender = (NotificationSender)this._notificationSenderServiceTrackerMap.getService((Object)notificationType);
            if (notificationSender == null) {
                throw new WorkflowException("Invalid notification type " + notificationType);
            }
            notificationSender.sendNotification(kaleoNotificationRecipient, notificationSubject, notificationMessage, executionContext);
        }
    }
}

