/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.notification;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.workflow.kaleo.definition.NotificationReceptionType;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.internal.helper.NotificationMessageHelper;
import com.liferay.portal.workflow.kaleo.runtime.notification.BaseNotificationSender;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationRecipient;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationSender;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"notification.type=user-notification"}, service={NotificationSender.class})
public class UserNotificationMessageSender
extends BaseNotificationSender
implements NotificationSender {
    @Reference(target="(model.class.name=com.liferay.change.tracking.model.CTCollection)")
    private ModelResourcePermission<CTCollection> _modelResourcePermission;
    @Reference
    private NotificationMessageHelper _notificationMessageHelper;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    protected void doSendNotification(Map<NotificationReceptionType, Set<NotificationRecipient>> notificationRecipients, String defaultSubject, String notificationMessage, ExecutionContext executionContext) throws Exception {
        JSONObject jsonObject = this._notificationMessageHelper.createMessageJSONObject(notificationMessage, executionContext);
        for (Map.Entry<NotificationReceptionType, Set<NotificationRecipient>> entry : notificationRecipients.entrySet()) {
            for (NotificationRecipient notificationRecipient : this.getDeliverableNotificationRecipients(entry.getValue(), 10002)) {
                User user;
                PermissionChecker permissionChecker;
                long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
                if (ctCollectionId > 0L && !this._modelResourcePermission.contains(permissionChecker = this._permissionCheckerFactory.create(user = this._userLocalService.fetchUser(notificationRecipient.getUserId())), ctCollectionId, "VIEW")) continue;
                this._userNotificationEventLocalService.sendUserNotificationEvents(notificationRecipient.getUserId(), "com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet", 10002, jsonObject);
            }
        }
    }
}

