/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.node;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.graph.PathElement;
import com.liferay.portal.workflow.kaleo.runtime.node.BaseNodeExecutor;
import com.liferay.portal.workflow.kaleo.runtime.node.NodeExecutor;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceTokenLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"node.type=JOIN"}, service={NodeExecutor.class})
public class JoinNodeExecutor
extends BaseNodeExecutor {
    @Reference
    private KaleoInstanceTokenLocalService _kaleoInstanceTokenLocalService;

    protected boolean doEnter(KaleoNode currentKaleoNode, ExecutionContext executionContext) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        this._kaleoInstanceTokenLocalService.completeKaleoInstanceToken(kaleoInstanceToken.getKaleoInstanceTokenId());
        return true;
    }

    protected void doExecute(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        KaleoInstanceToken parentKaleoInstanceToken = kaleoInstanceToken.getParentKaleoInstanceToken();
        if (parentKaleoInstanceToken.hasIncompleteChildrenKaleoInstanceToken()) {
            return;
        }
        parentKaleoInstanceToken = this._kaleoInstanceTokenLocalService.updateKaleoInstanceToken(parentKaleoInstanceToken.getKaleoInstanceTokenId(), currentKaleoNode.getKaleoNodeId());
        KaleoTransition kaleoTransition = currentKaleoNode.getDefaultKaleoTransition();
        ExecutionContext newExecutionContext = new ExecutionContext(parentKaleoInstanceToken, executionContext.getWorkflowContext(), executionContext.getServiceContext());
        PathElement pathElement = new PathElement(currentKaleoNode, kaleoTransition.getTargetKaleoNode(), newExecutionContext);
        remainingPathElements.add(pathElement);
    }

    protected void doExit(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) {
    }
}

