/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.condition;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.workflow.kaleo.definition.ScriptLanguage;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import com.liferay.portal.workflow.kaleo.model.KaleoCondition;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.condition.ConditionEvaluator;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={ConditionEvaluator.class})
public class MultiLanguageConditionEvaluator
implements ConditionEvaluator {
    private final Map<String, ConditionEvaluator> _conditionEvaluators = new HashMap<String, ConditionEvaluator>();

    public String evaluate(KaleoCondition kaleoCondition, ExecutionContext executionContext) throws PortalException {
        String conditionEvaluatorKey = this._getConditionEvaluatorKey(kaleoCondition.getScriptLanguage(), StringUtil.trim((String)kaleoCondition.getScript()));
        ConditionEvaluator conditionEvaluator = this._conditionEvaluators.get(conditionEvaluatorKey);
        if (conditionEvaluator == null) {
            throw new IllegalArgumentException("No condition evaluator found for script language " + conditionEvaluatorKey);
        }
        return conditionEvaluator.evaluate(kaleoCondition, executionContext);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(scripting.language=*)")
    protected void addConditionEvaluator(ConditionEvaluator conditionEvaluator, Map<String, Object> properties) throws KaleoDefinitionValidationException {
        String[] scriptingLanguages;
        for (String scriptingLanguage : scriptingLanguages = this._getScriptingLanguages(conditionEvaluator, properties)) {
            this._conditionEvaluators.put(this._getConditionEvaluatorKey(scriptingLanguage, ClassUtil.getClassName((Object)conditionEvaluator)), conditionEvaluator);
        }
    }

    protected void removeConditionEvaluator(ConditionEvaluator conditionEvaluator, Map<String, Object> properties) throws KaleoDefinitionValidationException {
        String[] scriptingLanguages;
        for (String scriptingLanguage : scriptingLanguages = this._getScriptingLanguages(conditionEvaluator, properties)) {
            this._conditionEvaluators.remove(this._getConditionEvaluatorKey(scriptingLanguage, ClassUtil.getClassName((Object)conditionEvaluator)));
        }
    }

    private String _getConditionEvaluatorKey(String language, String conditionEvaluatorClassName) throws KaleoDefinitionValidationException {
        ScriptLanguage scriptLanguage = ScriptLanguage.parse((String)language);
        if (scriptLanguage.equals(ScriptLanguage.JAVA)) {
            return language + ":" + conditionEvaluatorClassName;
        }
        return language;
    }

    private String[] _getScriptingLanguages(ConditionEvaluator conditionEvaluator, Map<String, Object> properties) {
        Object value = properties.get("scripting.language");
        Object[] scriptingLanguages = GetterUtil.getStringValues((Object)value, (String[])new String[]{String.valueOf(value)});
        if (ArrayUtil.isEmpty((Object[])scriptingLanguages)) {
            throw new IllegalArgumentException("The property \"scripting.language\" is invalid for " + ClassUtil.getClassName((Object)conditionEvaluator));
        }
        return scriptingLanguages;
    }
}

