/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.workflow.kaleo.definition.ExecutionType;
import com.liferay.portal.workflow.kaleo.model.KaleoAction;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.action.ActionExecutorManager;
import com.liferay.portal.workflow.kaleo.runtime.action.KaleoActionExecutor;
import com.liferay.portal.workflow.kaleo.service.KaleoActionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoLogLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={KaleoActionExecutor.class})
public class KaleoActionExecutorImpl
implements KaleoActionExecutor {
    @Reference
    protected ActionExecutorManager actionExecutorManager;
    private static final String _COMMENT_ACTION_SUCCESS = "Action completed successfully.";
    private static final Log _log = LogFactoryUtil.getLog(KaleoActionExecutorImpl.class);
    @Reference
    private KaleoActionLocalService _kaleoActionLocalService;
    @Reference
    private KaleoInstanceLocalService _kaleoInstanceLocalService;
    @Reference
    private KaleoLogLocalService _kaleoLogLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeKaleoActions(String kaleoClassName, long kaleoClassPK, ExecutionType executionType, ExecutionContext executionContext) throws PortalException {
        ServiceContext serviceContext = executionContext.getServiceContext();
        List kaleoActions = this._kaleoActionLocalService.getKaleoActions(serviceContext.getCompanyId(), kaleoClassName, kaleoClassPK, executionType.getValue());
        for (KaleoAction kaleoAction : kaleoActions) {
            long startTime = System.currentTimeMillis();
            String comment = _COMMENT_ACTION_SUCCESS;
            try {
                this.actionExecutorManager.executeKaleoAction(kaleoAction, executionContext);
                KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
                this._kaleoInstanceLocalService.updateKaleoInstance(kaleoInstanceToken.getKaleoInstanceId(), executionContext.getWorkflowContext(), serviceContext);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
                comment = exception.getMessage();
            }
            finally {
                this._kaleoLogLocalService.addActionExecutionKaleoLog(executionContext.getKaleoInstanceToken(), kaleoAction, startTime, System.currentTimeMillis(), comment, serviceContext);
            }
        }
    }
}

