/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.util.ExecutionContextHelper;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceTokenLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoLogLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskInstanceTokenLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTimerInstanceTokenLocalService;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ExecutionContextHelper.class})
public class ExecutionContextHelperImpl
implements ExecutionContextHelper {
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private KaleoInstanceTokenLocalService _kaleoInstanceTokenLocalService;
    @Reference
    private KaleoLogLocalService _kaleoLogLocalService;
    @Reference
    private KaleoTaskInstanceTokenLocalService _kaleoTaskInstanceTokenLocalService;
    @Reference
    private KaleoTimerInstanceTokenLocalService _kaleoTimerInstanceTokenLocalService;

    public void checkKaleoInstanceComplete(ExecutionContext executionContext) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        if (!kaleoInstanceToken.isCompleted()) {
            return;
        }
        KaleoInstance kaleoInstance = kaleoInstanceToken.getKaleoInstance();
        if (!kaleoInstance.isCompleted()) {
            return;
        }
        this._kaleoLogLocalService.addWorkflowInstanceEndKaleoLog(kaleoInstanceToken, executionContext.getServiceContext());
    }

    public void completeKaleoTimerInstances(ExecutionContext executionContext) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        List kaleoTimerInstanceTokens = this._kaleoTimerInstanceTokenLocalService.getKaleoTimerInstanceTokens(kaleoInstanceToken.getKaleoInstanceTokenId(), false, false, executionContext.getServiceContext());
        this._kaleoTimerInstanceTokenLocalService.completeKaleoTimerInstanceTokens(kaleoTimerInstanceTokens, executionContext.getServiceContext());
    }

    public String convert(ExecutionContext executionContext) {
        KaleoTaskInstanceToken kaleoTaskInstanceToken;
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        if (kaleoInstanceToken != null) {
            jsonObject.put("kaleoInstanceTokenId", kaleoInstanceToken.getKaleoInstanceTokenId());
        }
        if ((kaleoTaskInstanceToken = executionContext.getKaleoTaskInstanceToken()) != null) {
            jsonObject.put("kaleoTaskInstanceTokenId", kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId());
        }
        Map workflowContext = executionContext.getWorkflowContext();
        jsonObject.put("workflowContext", WorkflowContextUtil.convert((Map)workflowContext));
        ServiceContext serviceContext = executionContext.getServiceContext();
        jsonObject.put("serviceContext", this._jsonFactory.serialize((Object)serviceContext)).put("transitionName", executionContext.getTransitionName());
        return jsonObject.toString();
    }

    public ExecutionContext convert(String json) throws Exception {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
        KaleoInstanceToken kaleoInstanceToken = null;
        long kaleoInstanceTokenId = jsonObject.getLong("kaleoInstanceTokenId");
        if (kaleoInstanceTokenId > 0L) {
            kaleoInstanceToken = this._kaleoInstanceTokenLocalService.getKaleoInstanceToken(kaleoInstanceTokenId);
        }
        KaleoTaskInstanceToken kaleoTaskInstanceToken = null;
        long kaleoTaskInstanceTokenId = jsonObject.getLong("kaleoTaskInstanceTokenId");
        if (kaleoTaskInstanceTokenId > 0L) {
            kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(kaleoTaskInstanceTokenId);
        }
        Map workflowContext = WorkflowContextUtil.convert((String)jsonObject.getString("workflowContext"));
        ServiceContext serviceContext = (ServiceContext)this._jsonFactory.deserialize(jsonObject.getString("serviceContext"));
        return new ExecutionContext(kaleoInstanceToken, kaleoTaskInstanceToken, workflowContext, serviceContext);
    }

    public boolean isKaleoInstanceBlocked(ExecutionContext executionContext) {
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        int count = this._kaleoTimerInstanceTokenLocalService.getKaleoTimerInstanceTokensCount(kaleoInstanceToken.getKaleoInstanceTokenId(), true, false, executionContext.getServiceContext());
        return count > 0;
    }
}

