/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.timer.messaging;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.workflow.kaleo.model.KaleoTimerInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.WorkflowEngine;
import com.liferay.portal.workflow.kaleo.runtime.util.SchedulerUtil;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.service.KaleoTimerInstanceTokenLocalService;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={TimerMessageListener.class})
public class TimerMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(TimerMessageListener.class);
    @Reference
    private KaleoTimerInstanceTokenLocalService _kaleoTimerInstanceTokenLocalService;
    @Reference
    private WorkflowEngine _workflowEngine;

    protected void doReceive(Message message) throws Exception {
        long kaleoTimerInstanceTokenId = message.getLong("kaleoTimerInstanceTokenId");
        try {
            KaleoTimerInstanceToken kaleoTimerInstanceToken = this.getKaleoTimerInstanceToken(message);
            Map workflowContext = WorkflowContextUtil.convert((String)kaleoTimerInstanceToken.getWorkflowContext());
            ServiceContext serviceContext = (ServiceContext)workflowContext.get("serviceContext");
            this._workflowEngine.executeTimerWorkflowInstance(kaleoTimerInstanceTokenId, serviceContext, workflowContext);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to execute scheduled job. Unregistering job " + message), (Throwable)e);
            }
            String groupName = SchedulerUtil.getGroupName((long)kaleoTimerInstanceTokenId);
            SchedulerEngineHelperUtil.delete((String)groupName, (StorageType)StorageType.PERSISTED);
        }
    }

    protected KaleoTimerInstanceToken getKaleoTimerInstanceToken(Message message) throws PortalException {
        long kaleoTimerInstanceTokenId = message.getLong("kaleoTimerInstanceTokenId");
        return this._kaleoTimerInstanceTokenLocalService.getKaleoTimerInstanceToken(kaleoTimerInstanceTokenId);
    }
}

