/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.notification;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.notifications.UserNotificationManagerUtil;
import com.liferay.portal.workflow.kaleo.definition.NotificationReceptionType;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.internal.util.NotificationMessageHelper;
import com.liferay.portal.workflow.kaleo.runtime.notification.BaseNotificationSender;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationRecipient;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationSender;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"fromName=Liferay Portal Workflow Notifications", "notification.type=push-notification"}, service={NotificationSender.class})
public class PushNotificationMessageSender
extends BaseNotificationSender
implements NotificationSender {
    @Reference
    protected JSONFactory jsonFactory;
    @Reference
    protected MessageBus messageBus;
    @Reference
    protected NotificationMessageHelper notificationMessageHelper;
    private String _fromName;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._fromName = (String)properties.get("fromName");
    }

    protected Message createMessage(List<NotificationRecipient> notificationRecipients, String notificationMessage, ExecutionContext executionContext) {
        Message message = new Message();
        JSONObject payloadJSONObject = this.createPayloadJSONObject(notificationRecipients, notificationMessage, executionContext);
        message.setPayload((Object)payloadJSONObject);
        return message;
    }

    protected JSONObject createPayloadJSONObject(List<NotificationRecipient> notificationRecipients, String notificationMessage, ExecutionContext executionContext) {
        JSONObject jsonObject = this.notificationMessageHelper.createMessageJSONObject(notificationMessage, executionContext);
        jsonObject.put("body", notificationMessage).put("from", this._fromName).put("toUserIds", this.createUserIdsRecipientsJSONArray(notificationRecipients));
        return jsonObject;
    }

    protected JSONArray createUserIdsRecipientsJSONArray(List<NotificationRecipient> notificationRecipients) {
        JSONArray jsonArray = this.jsonFactory.createJSONArray();
        Stream stream = notificationRecipients.stream();
        stream.filter(notificationRecipient -> notificationRecipient.getUserId() > 0L).forEach(notificationRecipient -> jsonArray.put(notificationRecipient.getUserId()));
        return jsonArray;
    }

    protected void doSendNotification(Map<NotificationReceptionType, Set<NotificationRecipient>> notificationRecipientsMap, String defaultSubject, String notificationMessage, ExecutionContext executionContext) throws Exception {
        ArrayList<NotificationRecipient> notificationRecipients = new ArrayList<NotificationRecipient>();
        Collection<Set<NotificationRecipient>> notificationRecipientsCollection = notificationRecipientsMap.values();
        Iterator<Set<NotificationRecipient>> iterator = notificationRecipientsCollection.iterator();
        for (NotificationRecipient notificationRecipient : iterator.next()) {
            if (!UserNotificationManagerUtil.isDeliver((long)notificationRecipient.getUserId(), (String)"com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet", (long)0L, (int)0, (int)10005)) continue;
            notificationRecipients.add(notificationRecipient);
        }
        Message message = this.createMessage(notificationRecipients, notificationMessage, executionContext);
        this.messageBus.sendMessage("liferay/push_notification", message);
    }
}

