/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.calendar;

import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.workflow.kaleo.definition.DelayDuration;
import com.liferay.portal.workflow.kaleo.definition.DurationScale;
import com.liferay.portal.workflow.kaleo.runtime.calendar.DueDateCalculator;
import java.util.Calendar;
import java.util.Date;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={DueDateCalculator.class})
public class DefaultDueDateCalculator
implements DueDateCalculator {
    public Date getDueDate(Date startDate, DelayDuration delayDuration) {
        Calendar cal = CalendarFactoryUtil.getCalendar();
        cal.setTime(startDate);
        DurationScale durationScale = delayDuration.getDurationScale();
        int duration = (int)Math.round(delayDuration.getDuration());
        if (durationScale.equals((Object)DurationScale.SECOND)) {
            cal.add(13, duration);
        } else if (durationScale.equals((Object)DurationScale.MINUTE)) {
            cal.add(12, duration);
        } else if (durationScale.equals((Object)DurationScale.HOUR)) {
            cal.add(10, duration);
        } else if (durationScale.equals((Object)DurationScale.DAY)) {
            cal.add(6, duration);
        } else if (durationScale.equals((Object)DurationScale.MONTH)) {
            cal.add(2, duration);
        } else if (durationScale.equals((Object)DurationScale.YEAR)) {
            cal.add(1, duration);
        }
        return cal.getTime();
    }
}

