/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.KaleoSignaler;
import com.liferay.portal.workflow.kaleo.runtime.graph.PathElement;
import com.liferay.portal.workflow.kaleo.runtime.internal.BaseKaleoBean;
import com.liferay.portal.workflow.kaleo.runtime.internal.node.NodeExecutorFactory;
import com.liferay.portal.workflow.kaleo.runtime.node.NodeExecutor;
import com.liferay.portal.workflow.kaleo.runtime.util.ExecutionContextHelper;
import java.util.ArrayList;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Transactional(isolation=Isolation.PORTAL, propagation=Propagation.SUPPORTS, rollbackFor={Exception.class})
@Component(immediate=true, service={AopService.class})
public class DefaultKaleoSignaler
extends BaseKaleoBean
implements AopService,
KaleoSignaler {
    @Reference
    private ExecutionContextHelper _executionContextHelper;
    @Reference
    private MessageBus _messageBus;
    @Reference
    private NodeExecutorFactory _nodeExecutorFactory;

    public void signalEntry(String transitionName, ExecutionContext executionContext) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        executionContext.setTransitionName(transitionName);
        PathElement startPathElement = new PathElement(null, kaleoInstanceToken.getCurrentKaleoNode(), executionContext);
        this._sendPathElement(startPathElement);
    }

    @Transactional(isolation=Isolation.PORTAL, propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void signalExecute(KaleoNode currentKaleoNode, ExecutionContext executionContext) throws PortalException {
        NodeExecutor nodeExecutor = this._nodeExecutorFactory.getNodeExecutor(currentKaleoNode.getType());
        ArrayList remainingPathElements = new ArrayList();
        nodeExecutor.execute(currentKaleoNode, executionContext, remainingPathElements);
        this._executionContextHelper.checkKaleoInstanceComplete(executionContext);
        for (PathElement remainingPathElement : remainingPathElements) {
            this._sendPathElement(remainingPathElement);
        }
    }

    public void signalExit(String transitionName, ExecutionContext executionContext) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        executionContext.setTransitionName(transitionName);
        PathElement pathElement = new PathElement(kaleoInstanceToken.getCurrentKaleoNode(), null, executionContext);
        this._sendPathElement(pathElement);
    }

    private void _sendPathElement(PathElement pathElement) {
        Message message = new Message();
        message.setPayload((Object)pathElement);
        this._messageBus.sendMessage("liferay/kaleo_graph_walker", message);
    }
}

