/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.notification;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.workflow.kaleo.definition.NotificationReceptionType;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.internal.util.NotificationMessageHelper;
import com.liferay.portal.workflow.kaleo.runtime.notification.BaseNotificationSender;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationRecipient;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationSender;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"fromName=Liferay Portal Workflow Notifications", "notification.type=push-notification"}, service={NotificationSender.class})
public class PushNotificationMessageSender
extends BaseNotificationSender
implements NotificationSender {
    @Reference
    protected JSONFactory jsonFactory;
    @Reference
    protected MessageBus messageBus;
    @Reference
    protected NotificationMessageHelper notificationMessageHelper;
    private String _fromName;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._fromName = (String)properties.get("fromName");
    }

    protected Message createMessage(Collection<Set<NotificationRecipient>> notificationRecipients, String notificationMessage, ExecutionContext executionContext) {
        Message message = new Message();
        JSONObject payloadJSONObject = this.createPayloadJSONObject(notificationRecipients, notificationMessage, executionContext);
        message.setPayload((Object)payloadJSONObject);
        return message;
    }

    protected JSONObject createPayloadJSONObject(Collection<Set<NotificationRecipient>> notificationRecipients, String notificationMessage, ExecutionContext executionContext) {
        JSONObject jsonObject = this.notificationMessageHelper.createMessageJSONObject(notificationMessage, executionContext);
        jsonObject.put("body", notificationMessage);
        jsonObject.put("from", this._fromName);
        jsonObject.put("toUserIds", this.createUserIdsRecipientsJSONArray(notificationRecipients.stream()));
        return jsonObject;
    }

    protected JSONArray createUserIdsRecipientsJSONArray(Stream<Set<NotificationRecipient>> notificationRecipientsSetStream) {
        JSONArray jsonArray = this.jsonFactory.createJSONArray();
        Stream notificationRecipientStream = notificationRecipientsSetStream.flatMap(notificationRecipientSet -> notificationRecipientSet.stream());
        notificationRecipientStream.filter(notificationRecipient -> notificationRecipient.getUserId() > 0L).forEach(notificationRecipient -> jsonArray.put(notificationRecipient.getUserId()));
        return jsonArray;
    }

    protected void doSendNotification(Map<NotificationReceptionType, Set<NotificationRecipient>> notificationRecipients, String defaultSubject, String notificationMessage, ExecutionContext executionContext) throws Exception {
        Message message = this.createMessage(notificationRecipients.values(), notificationMessage, executionContext);
        this.messageBus.sendMessage("liferay/push_notification", message);
    }
}

