/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.notification;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationSender;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={NotificationSenderFactory.class})
public class NotificationSenderFactory {
    private final Map<String, NotificationSender> _notificationSenders = new HashMap<String, NotificationSender>();

    public NotificationSender getNotificationSender(String notificationType) throws WorkflowException {
        NotificationSender notificationSender = this._notificationSenders.get(notificationType);
        if (notificationSender == null) {
            throw new WorkflowException("Invalid notification type " + notificationType);
        }
        return notificationSender;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(notification.type=*)")
    protected void addNotificationSender(NotificationSender notificationSender, Map<String, Object> properties) {
        String[] notificationTypes;
        for (String notificationType : notificationTypes = this.getNotificationTypes(notificationSender, properties)) {
            this._notificationSenders.put(notificationType, notificationSender);
        }
    }

    protected String[] getNotificationTypes(NotificationSender notificationSender, Map<String, Object> properties) {
        Object value = properties.get("notification.type");
        Object[] notificationTypes = GetterUtil.getStringValues((Object)value, (String[])new String[]{String.valueOf(value)});
        if (ArrayUtil.isEmpty((Object[])notificationTypes)) {
            throw new IllegalArgumentException("The property \"notification.type\" is invalid for " + ClassUtil.getClassName((Object)notificationSender));
        }
        return notificationTypes;
    }

    protected void removeNotificationSender(NotificationSender notificationSender, Map<String, Object> properties) {
        String[] notificationTypes;
        for (String notificationType : notificationTypes = this.getNotificationTypes(notificationSender, properties)) {
            this._notificationSenders.remove(notificationType);
        }
    }
}

