/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.assignment;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignment;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.assignment.TaskAssignmentSelector;
import com.liferay.portal.workflow.kaleo.runtime.assignment.TaskAssignmentSelectorRegistry;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskAssignmentInstanceLocalService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={TaskAssignerUtil.class})
public class TaskAssignerUtil {
    @Reference
    private KaleoTaskAssignmentInstanceLocalService _kaleoTaskAssignmentInstanceLocalService;
    @Reference
    private TaskAssignmentSelectorRegistry _taskAssignmentSelectorRegistry;

    public void reassignKaleoTask(List<KaleoTaskAssignment> kaleoTaskAssignments, ExecutionContext executionContext) throws PortalException {
        ArrayList reassignedKaleoTaskAssignments = new ArrayList();
        for (KaleoTaskAssignment kaleoTaskAssignment : kaleoTaskAssignments) {
            String assigneeClassName = kaleoTaskAssignment.getAssigneeClassName();
            TaskAssignmentSelector taskAssignmentSelector = this._taskAssignmentSelectorRegistry.getTaskAssignmentSelector(assigneeClassName);
            Collection calculatedKaleoTaskAssignments = taskAssignmentSelector.calculateTaskAssignments(kaleoTaskAssignment, executionContext);
            reassignedKaleoTaskAssignments.addAll(calculatedKaleoTaskAssignments);
        }
        KaleoTaskInstanceToken kaleoTaskInstanceToken = executionContext.getKaleoTaskInstanceToken();
        this._kaleoTaskAssignmentInstanceLocalService.deleteKaleoTaskAssignmentInstances(kaleoTaskInstanceToken);
        this._kaleoTaskAssignmentInstanceLocalService.addTaskAssignmentInstances(kaleoTaskInstanceToken, reassignedKaleoTaskAssignments, executionContext.getWorkflowContext(), executionContext.getServiceContext());
    }
}

