/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={NotificationMessageHelper.class})
public class NotificationMessageHelper {
    @Reference
    protected JSONFactory jsonFactory;
    private static final Log _log = LogFactoryUtil.getLog(NotificationMessageHelper.class);

    public JSONObject createMessageJSONObject(String notificationMessage, ExecutionContext executionContext) {
        JSONObject jsonObject = this.jsonFactory.createJSONObject();
        Map workflowContext = executionContext.getWorkflowContext();
        jsonObject.put("companyId", String.valueOf(workflowContext.get("companyId")));
        jsonObject.put("entryClassName", (String)workflowContext.get("entryClassName"));
        jsonObject.put("entryClassPK", String.valueOf(workflowContext.get("entryClassPK")));
        jsonObject.put("entryType", (String)workflowContext.get("entryType"));
        jsonObject.put("groupId", String.valueOf(workflowContext.get("groupId")));
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        long userId = this.getUserId(executionContext, kaleoInstanceToken);
        jsonObject.put("userId", String.valueOf(userId));
        jsonObject.put("notificationMessage", notificationMessage);
        jsonObject.put("workflowInstanceId", kaleoInstanceToken.getKaleoInstanceId());
        KaleoTaskInstanceToken kaleoTaskInstanceToken = executionContext.getKaleoTaskInstanceToken();
        if (kaleoTaskInstanceToken != null) {
            jsonObject.put("workflowTaskId", kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId());
        }
        return jsonObject;
    }

    protected long getUserId(ExecutionContext executionContext, KaleoInstanceToken kaleoInstanceToken) {
        try {
            ServiceContext serviceContext = executionContext.getServiceContext();
            return serviceContext.getGuestOrUserId();
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to get user from context, using userId from kaleoInstanceToken instead", (Throwable)pe);
            }
            return kaleoInstanceToken.getUserId();
        }
    }
}

