/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.notification;

import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.portal.kernel.notifications.UserNotificationManagerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.NotificationReceptionType;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.internal.settings.WorkflowGroupServiceSettings;
import com.liferay.portal.workflow.kaleo.runtime.notification.BaseNotificationSender;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationRecipient;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationSender;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"fromAddress=no-reply@liferay.com", "fromName=Liferay Portal Workflow Notifications", "notification.type=email"}, service={NotificationSender.class})
public class EmailNotificationSender
extends BaseNotificationSender
implements NotificationSender {
    private String _fromAddress;
    private String _fromName;
    @Reference
    private MailService _mailService;

    protected void activate(Map<String, Object> properties) {
        this._fromAddress = (String)properties.get("fromAddress");
        this._fromName = (String)properties.get("fromName");
    }

    protected void doSendNotification(Map<NotificationReceptionType, Set<NotificationRecipient>> notificationRecipients, String defaultSubject, String notificationMessage, ExecutionContext executionContext) throws Exception {
        String fromName;
        Map workflowContext = executionContext.getWorkflowContext();
        long companyId = GetterUtil.getLong(workflowContext.get("companyId"));
        WorkflowGroupServiceSettings workflowGroupServiceSettings = WorkflowGroupServiceSettings.getInstance(companyId);
        String fromAddress = (String)workflowContext.get("notificationSenderAddress");
        if (Validator.isNull((String)fromAddress)) {
            fromAddress = workflowGroupServiceSettings.getEmailFromAddress();
        }
        if (Validator.isNull((String)fromAddress)) {
            fromAddress = this._fromAddress;
        }
        if (Validator.isNull((String)(fromName = (String)workflowContext.get("notificationSenderName")))) {
            fromName = workflowGroupServiceSettings.getEmailFromName();
        }
        if (Validator.isNull((String)fromName)) {
            fromName = this._fromName;
        }
        InternetAddress from = new InternetAddress(fromAddress, fromName);
        String subject = (String)workflowContext.get("notificationSubject");
        if (Validator.isNull((String)subject)) {
            subject = defaultSubject;
        }
        MailMessage mailMessage = new MailMessage(from, subject, notificationMessage, true);
        mailMessage.setCC(this.getInternetAddresses(notificationRecipients.get(NotificationReceptionType.CC)));
        mailMessage.setBCC(this.getInternetAddresses(notificationRecipients.get(NotificationReceptionType.BCC)));
        ArrayList<InternetAddress> internetAddresses = new ArrayList<InternetAddress>();
        Collection<Set<NotificationRecipient>> notificationRecipientsCollection = notificationRecipients.values();
        Iterator<Set<NotificationRecipient>> iterator = notificationRecipientsCollection.iterator();
        for (NotificationRecipient notificationRecipient : iterator.next()) {
            if (!UserNotificationManagerUtil.isDeliver((long)notificationRecipient.getUserId(), (String)"com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet", (long)0L, (int)0, (int)10000)) continue;
            internetAddresses.add(notificationRecipient.getInternetAddress());
        }
        mailMessage.setBulkAddresses(internetAddresses.toArray(new InternetAddress[internetAddresses.size()]));
        this._mailService.sendEmail(mailMessage);
    }

    protected InternetAddress[] getInternetAddresses(Set<NotificationRecipient> notificationRecipients) throws AddressException, UnsupportedEncodingException {
        if (notificationRecipients == null) {
            return new InternetAddress[0];
        }
        ArrayList<InternetAddress> internetAddresses = new ArrayList<InternetAddress>(notificationRecipients.size());
        for (NotificationRecipient notificationRecipient : notificationRecipients) {
            internetAddresses.add(notificationRecipient.getInternetAddress());
        }
        return internetAddresses.toArray(new InternetAddress[internetAddresses.size()]);
    }
}

