/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.notification;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.notifications.UserNotificationManagerUtil;
import com.liferay.portal.workflow.kaleo.definition.NotificationReceptionType;
import com.liferay.portal.workflow.kaleo.definition.RecipientType;
import com.liferay.portal.workflow.kaleo.model.KaleoNotificationRecipient;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationMessageSenderException;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationRecipient;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationSender;
import com.liferay.portal.workflow.kaleo.runtime.notification.recipient.NotificationRecipientBuilder;
import com.liferay.portal.workflow.kaleo.runtime.notification.recipient.NotificationRecipientBuilderRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseNotificationSender
implements NotificationSender {
    @Reference
    protected NotificationRecipientBuilderRegistry notificationRecipientBuilderRegistry;

    @Override
    public void sendNotification(List<KaleoNotificationRecipient> kaleoNotificationRecipients, String defaultSubject, String notificationMessage, ExecutionContext executionContext) throws NotificationMessageSenderException {
        try {
            Map<NotificationReceptionType, Set<NotificationRecipient>> notificationRecipientsMap = this.getNotificationRecipientsMap(kaleoNotificationRecipients, executionContext);
            if (notificationRecipientsMap.isEmpty()) {
                return;
            }
            this.doSendNotification(notificationRecipientsMap, defaultSubject, notificationMessage, executionContext);
        }
        catch (Exception exception) {
            throw new NotificationMessageSenderException("Unable to send notification message", exception);
        }
    }

    protected abstract void doSendNotification(Map<NotificationReceptionType, Set<NotificationRecipient>> var1, String var2, String var3, ExecutionContext var4) throws Exception;

    protected Set<NotificationRecipient> getDeliverableNotificationRecipients(Set<NotificationRecipient> notificationRecipients, int notificationDeliveryType) throws PortalException {
        HashSet<NotificationRecipient> newNotificationRecipients = new HashSet<NotificationRecipient>();
        if (notificationRecipients == null) {
            return newNotificationRecipients;
        }
        for (NotificationRecipient notificationRecipient : notificationRecipients) {
            if (notificationRecipient.getUserId() <= 0L || !UserNotificationManagerUtil.isDeliver((long)notificationRecipient.getUserId(), (String)"com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet", (long)0L, (int)0, (int)notificationDeliveryType)) continue;
            newNotificationRecipients.add(notificationRecipient);
        }
        return newNotificationRecipients;
    }

    protected Map<NotificationReceptionType, Set<NotificationRecipient>> getNotificationRecipientsMap(List<KaleoNotificationRecipient> kaleoNotificationRecipients, ExecutionContext executionContext) throws Exception {
        HashMap<NotificationReceptionType, Set<NotificationRecipient>> notificationRecipientsMap = new HashMap<NotificationReceptionType, Set<NotificationRecipient>>();
        if (kaleoNotificationRecipients.isEmpty()) {
            Set<NotificationRecipient> notificationRecipients = this.retrieveNotificationRecipients(notificationRecipientsMap, NotificationReceptionType.TO);
            NotificationRecipientBuilder notificationRecipientBuilder = this.notificationRecipientBuilderRegistry.getNotificationRecipientBuilder(RecipientType.ASSIGNEES);
            notificationRecipientBuilder.processKaleoNotificationRecipient(notificationRecipients, null, NotificationReceptionType.TO, executionContext);
            return notificationRecipientsMap;
        }
        for (KaleoNotificationRecipient kaleoNotificationRecipient : kaleoNotificationRecipients) {
            NotificationReceptionType notificationReceptionType = NotificationReceptionType.parse((String)kaleoNotificationRecipient.getNotificationReceptionType());
            Set<NotificationRecipient> notificationRecipients = this.retrieveNotificationRecipients(notificationRecipientsMap, notificationReceptionType);
            RecipientType recipientType = RecipientType.parse((String)kaleoNotificationRecipient.getRecipientClassName());
            NotificationRecipientBuilder notificationRecipientBuilder = this.notificationRecipientBuilderRegistry.getNotificationRecipientBuilder(recipientType);
            notificationRecipientBuilder.processKaleoNotificationRecipient(notificationRecipients, kaleoNotificationRecipient, notificationReceptionType, executionContext);
        }
        return notificationRecipientsMap;
    }

    protected Set<NotificationRecipient> retrieveNotificationRecipients(Map<NotificationReceptionType, Set<NotificationRecipient>> notificationRecipientsMap, NotificationReceptionType notificationReceptionType) {
        Set<NotificationRecipient> notificationRecipients = notificationRecipientsMap.get(notificationReceptionType);
        if (notificationRecipients == null) {
            notificationRecipients = new HashSet<NotificationRecipient>();
            notificationRecipientsMap.put(notificationReceptionType, notificationRecipients);
        }
        return notificationRecipients;
    }
}

