Liferay.Loader.define('liferay!portal-workflow-instance-tracker-web$react-redux@7.2.8/es/components/Provider', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import React, { useMemo } from 'react';
    import PropTypes from 'prop-types';
    import { ReactReduxContext } from './Context';
    import { createSubscription } from '../utils/Subscription';
    import { useIsomorphicLayoutEffect } from '../utils/useIsomorphicLayoutEffect';

    function Provider(_ref) {
      var store = _ref.store,
          context = _ref.context,
          children = _ref.children;
      var contextValue = useMemo(function () {
        var subscription = createSubscription(store);
        return {
          store: store,
          subscription: subscription
        };
      }, [store]);
      var previousState = useMemo(function () {
        return store.getState();
      }, [store]);
      useIsomorphicLayoutEffect(function () {
        var subscription = contextValue.subscription;
        subscription.onStateChange = subscription.notifyNestedSubs;
        subscription.trySubscribe();

        if (previousState !== store.getState()) {
          subscription.notifyNestedSubs();
        }

        return function () {
          subscription.tryUnsubscribe();
          subscription.onStateChange = null;
        };
      }, [contextValue, previousState]);

      return (/*#__PURE__*/React.createElement((context || ReactReduxContext).Provider, {
          value: contextValue
        }, children)
      );
    }

    export default Provider;
  }
});
//# sourceMappingURL=Provider.js.map