/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.maven;

import com.liferay.portal.tools.bundle.support.commands.DistBundleCommand;
import com.liferay.portal.tools.bundle.support.internal.util.BundleSupportUtil;
import com.liferay.portal.tools.bundle.support.internal.util.FileUtil;
import com.liferay.portal.tools.bundle.support.internal.util.MavenUtil;
import com.liferay.portal.tools.bundle.support.maven.InitBundleMojo;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="dist")
public class DistBundleMojo
extends InitBundleMojo {
    @Parameter
    protected String archiveFileName;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.${project.packaging}", required=true)
    protected File deployFile;
    @Parameter(defaultValue="tar.gz", required=true)
    protected String format;
    @Parameter(defaultValue="true", required=true)
    protected boolean includeFolder;
    @Parameter(defaultValue="${project.artifactId}.${project.packaging}", required=true)
    protected String outputFileName;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute() throws MojoExecutionException {
        MavenProject rootProject = MavenUtil.getRootProject(this.project);
        Build build = rootProject.getBuild();
        if (this.archiveFileName == null) {
            this.archiveFileName = rootProject.getArtifactId();
        }
        String archiveLocation = build.getDirectory() + "/" + this.archiveFileName;
        this.setLiferayHome(archiveLocation);
        File archiveFile = new File(archiveLocation + "." + this.format);
        String packaging = this.project.getPackaging();
        try {
            if (packaging.equals("jar") || packaging.equals("war")) {
                String deployDirName = BundleSupportUtil.getDeployDirName(this.deployFile.getName());
                if (this.includeFolder) {
                    deployDirName = this.archiveFileName + "/" + deployDirName;
                }
                Path entryPath = Paths.get(deployDirName, this.outputFileName);
                if (this.format.equals("zip")) {
                    FileUtil.appendZip(this.deployFile, entryPath, archiveFile);
                    return;
                } else {
                    if (!this.format.equals("gz") && !this.format.equals("tar") && !this.format.equals("tar.gz") && !this.format.equals("tgz")) throw new IllegalArgumentException("Please specify either zip or tar.gz or tgz");
                    FileUtil.appendTar(this.deployFile, entryPath, archiveFile);
                }
                return;
            } else {
                if (this.project.hasParent()) return;
                archiveFile.delete();
                File liferayHomeDir = this.getLiferayHomeDir();
                super.execute();
                DistBundleCommand distBundleCommand = new DistBundleCommand();
                distBundleCommand.setFormat(this.format);
                distBundleCommand.setIncludeFolder(this.includeFolder);
                distBundleCommand.setLiferayHomeDir(this.getLiferayHomeDir());
                distBundleCommand.setOutputFile(archiveFile);
                distBundleCommand.execute();
                FileUtil.deleteDirectory(liferayHomeDir.toPath());
            }
            return;
        }
        catch (MojoExecutionException mee) {
            throw mee;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to create distributable bundle", e);
        }
    }
}

