"use strict";

Liferay.Loader.define("portal-template-react-renderer-impl$dnd-core@7.7.0/lib/cjs/utils/equality", ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.strictEquality = function (a, b) {
        return a === b;
    };
    /**
     * Determine if two cartesian coordinate offsets are equal
     * @param offsetA
     * @param offsetB
     */
    function areCoordsEqual(offsetA, offsetB) {
        if (!offsetA && !offsetB) {
            return true;
        } else if (!offsetA || !offsetB) {
            return false;
        } else {
            return offsetA.x === offsetB.x && offsetA.y === offsetB.y;
        }
    }
    exports.areCoordsEqual = areCoordsEqual;
    /**
     * Determines if two arrays of items are equal
     * @param a The first array of items
     * @param b The second array of items
     */
    function areArraysEqual(a, b, isEqual) {
        if (isEqual === void 0) {
            isEqual = exports.strictEquality;
        }
        if (a.length !== b.length) {
            return false;
        }
        for (var i = 0; i < a.length; ++i) {
            if (!isEqual(a[i], b[i])) {
                return false;
            }
        }
        return true;
    }
    exports.areArraysEqual = areArraysEqual;
});
//# sourceMappingURL=equality.js.map