/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.loader;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.configuration.ServiceComponentConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.osgi.framework.Bundle;

public class ModuleResourceLoader
implements ServiceComponentConfiguration {
    private static final Log _log = LogFactoryUtil.getLog(ModuleResourceLoader.class);
    private final Bundle _bundle;

    public ModuleResourceLoader(Bundle bundle) {
        this._bundle = bundle;
    }

    public InputStream getHibernateInputStream() {
        return this.getInputStream("/META-INF/module-hbm.xml");
    }

    public InputStream getModelHintsExtInputStream() {
        return this.getInputStream("/META-INF/portlet-model-hints-ext.xml");
    }

    public InputStream getModelHintsInputStream() {
        return this.getInputStream("/META-INF/portlet-model-hints.xml");
    }

    public String getServletContextName() {
        return this._bundle.getSymbolicName();
    }

    public InputStream getSQLIndexesInputStream() {
        return this.getInputStream("/META-INF/sql/indexes.sql");
    }

    public InputStream getSQLSequencesInputStream() {
        return this.getInputStream("/META-INF/sql/sequences.sql");
    }

    public InputStream getSQLTablesInputStream() {
        return this.getInputStream("/META-INF/sql/tables.sql");
    }

    protected InputStream getInputStream(String location) {
        URL url = this._bundle.getResource(location);
        if (url == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to find " + location));
            }
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
        }
        catch (IOException ioe) {
            _log.error((Object)("Unable to read " + location), (Throwable)ioe);
        }
        return inputStream;
    }
}

