/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.context;

import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.configurator.ConfigurableApplicationContextConfigurator;
import com.liferay.portal.spring.extender.internal.bean.ApplicationContextServicePublisherUtil;
import com.liferay.portal.spring.extender.internal.context.ModuleApplicationContext;
import com.liferay.portal.spring.extender.internal.context.ModuleBeanFactoryPostProcessor;
import com.liferay.portal.spring.extender.internal.jdbc.DataSourceUtil;
import java.beans.Introspector;
import java.util.Dictionary;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class ModuleApplicationContextRegistrator {
    private ConfigurableApplicationContext _configurableApplicationContext;
    private final ConfigurableApplicationContextConfigurator _configurableApplicationContextConfigurator;
    private final Bundle _extendeeBundle;
    private final Bundle _extenderBundle;
    private List<ServiceRegistration<?>> _serviceRegistrations;

    public ModuleApplicationContextRegistrator(ConfigurableApplicationContextConfigurator configurableApplicationContextConfigurator, Bundle extendeeBundle, Bundle extenderBundle) {
        this._configurableApplicationContextConfigurator = configurableApplicationContextConfigurator;
        this._extendeeBundle = extendeeBundle;
        this._extenderBundle = extenderBundle;
    }

    protected void start() throws Exception {
        BundleWiring extendeeBundleWiring = (BundleWiring)this._extendeeBundle.adapt(BundleWiring.class);
        ClassLoader extendeeClassLoader = extendeeBundleWiring.getClassLoader();
        BundleWiring extenderBundleWiring = (BundleWiring)this._extenderBundle.adapt(BundleWiring.class);
        ClassLoader extenderClassLoader = extenderBundleWiring.getClassLoader();
        ClassLoader classLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader)extendeeClassLoader, (ClassLoader[])new ClassLoader[]{extenderClassLoader});
        try {
            Dictionary headers = this._extendeeBundle.getHeaders("");
            this._configurableApplicationContext = new ModuleApplicationContext(this._extendeeBundle, classLoader, StringUtil.split((String)((String)headers.get("Liferay-Spring-Context")), (char)','));
            this._configurableApplicationContext.addBeanFactoryPostProcessor(beanFactory -> {
                if (!beanFactory.containsBean("liferayDataSource")) {
                    DataSource dataSource = DataSourceUtil.getDataSource(extendeeClassLoader);
                    beanFactory.registerSingleton("liferayDataSource", (Object)dataSource);
                }
            });
            this._configurableApplicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new ModuleBeanFactoryPostProcessor(this._extendeeBundle.getBundleContext()));
            this._configurableApplicationContextConfigurator.configure(this._configurableApplicationContext);
            this._configurableApplicationContext.refresh();
            BundleWiring bundleWiring = (BundleWiring)this._extendeeBundle.adapt(BundleWiring.class);
            PortletBeanLocatorUtil.setBeanLocator((String)this._extendeeBundle.getSymbolicName(), (BeanLocator)new BeanLocatorImpl(bundleWiring.getClassLoader(), (ApplicationContext)this._configurableApplicationContext));
            this._serviceRegistrations = ApplicationContextServicePublisherUtil.registerContext(this._configurableApplicationContext, this._extendeeBundle.getBundleContext());
        }
        catch (Exception e) {
            throw new Exception("Unable to start " + this._extendeeBundle.getSymbolicName(), e);
        }
        finally {
            CachedIntrospectionResults.clearClassLoader((ClassLoader)classLoader);
            CachedIntrospectionResults.clearClassLoader((ClassLoader)extendeeClassLoader);
            CachedIntrospectionResults.clearClassLoader((ClassLoader)extenderClassLoader);
            Introspector.flushCaches();
        }
    }

    protected void stop() {
        ApplicationContextServicePublisherUtil.unregisterContext(this._serviceRegistrations);
        PortletBeanLocatorUtil.setBeanLocator((String)this._extendeeBundle.getSymbolicName(), null);
        this._configurableApplicationContext.close();
        this._configurableApplicationContext = null;
    }
}

