/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.context;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.configurator.ConfigurableApplicationContextConfigurator;
import com.liferay.portal.spring.extender.internal.configuration.ConfigurationUtil;
import com.liferay.portal.spring.extender.internal.context.ModuleApplicationContextRegistrator;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Dictionary;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.ServiceDependency;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(immediate=true, service={})
public class ModuleApplicationContextExtender
implements BundleTrackerCustomizer<ModuleApplicationContextExtension> {
    private static final Log _log = LogFactoryUtil.getLog(ModuleApplicationContextExtender.class);
    private BundleContext _bundleContext;
    private BundleTracker<?> _bundleTracker;
    @Reference
    private ConfigurableApplicationContextConfigurator _configurableApplicationContextConfigurator;
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;

    public ModuleApplicationContextExtension addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        Dictionary headers = bundle.getHeaders("");
        if (headers.get("Liferay-Spring-Context") == null) {
            return null;
        }
        try {
            ModuleApplicationContextExtension moduleApplicationContextExtension = new ModuleApplicationContextExtension(bundle);
            moduleApplicationContextExtension.start();
            return moduleApplicationContextExtension;
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return null;
        }
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, ModuleApplicationContextExtension moduleApplicationContextExtension) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, ModuleApplicationContextExtension moduleApplicationContextExtension) {
        moduleApplicationContextExtension.destroy();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._bundleTracker = new BundleTracker(bundleContext, 40, (BundleTrackerCustomizer)this);
        this._bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
    }

    public class ModuleApplicationContextExtension {
        private final Bundle _bundle;
        private org.apache.felix.dm.Component _component;
        private final DependencyManager _dependencyManager;

        public ModuleApplicationContextExtension(Bundle bundle) {
            this._bundle = bundle;
            this._dependencyManager = new DependencyManager(bundle.getBundleContext());
        }

        public void destroy() {
            if (this._component != null) {
                this._dependencyManager.remove(this._component);
            }
        }

        public void start() throws Exception {
            String requireSchemaVersion;
            this._component = this._dependencyManager.createComponent();
            BundleContext bundleContext = ModuleApplicationContextExtender.this._bundleContext;
            this._component.setImplementation((Object)new ModuleApplicationContextRegistrator(ModuleApplicationContextExtender.this._configurableApplicationContextConfigurator, this._bundle, bundleContext.getBundle()));
            BundleWiring bundleWiring = (BundleWiring)this._bundle.adapt(BundleWiring.class);
            ClassLoader classLoader = bundleWiring.getClassLoader();
            this._processServiceReferences(classLoader);
            Dictionary headers = this._bundle.getHeaders("");
            String liferayService = (String)headers.get("Liferay-Service");
            if (liferayService != null) {
                this._generateConfigurationDependency(classLoader, "portlet");
                this._generateConfigurationDependency(classLoader, "service");
            }
            if (Validator.isNull((String)(requireSchemaVersion = (String)headers.get("Liferay-Require-SchemaVersion")))) {
                this._generateReleaseDependency();
            }
            this._dependencyManager.add(this._component);
        }

        private void _generateConfigurationDependency(ClassLoader classLoader, String name) {
            if (ConfigurationUtil.hasConfiguration(classLoader, name)) {
                ServiceDependency serviceDependency = this._dependencyManager.createServiceDependency();
                serviceDependency.setRequired(true);
                serviceDependency.setService(Configuration.class, StringBundler.concat((String[])new String[]{"(&(origin.bundle.symbolic.name=", this._bundle.getSymbolicName(), ")(name=", name, "))"}));
                this._component.add(new Dependency[]{serviceDependency});
            }
        }

        private void _generateReleaseDependency() {
            ServiceDependency serviceDependency = this._dependencyManager.createServiceDependency();
            serviceDependency.setRequired(true);
            serviceDependency.setService(Release.class, StringBundler.concat((Object[])new Object[]{"(&(release.bundle.symbolic.name=", this._bundle.getSymbolicName(), ")(release.schema.version=", this._bundle.getVersion(), "))"}));
            this._component.add(new Dependency[]{serviceDependency});
        }

        private void _processServiceReferences(ClassLoader classLoader) throws Exception {
            URL url = this._bundle.getEntry("OSGI-INF/context/context.dependencies");
            if (url == null) {
                return;
            }
            try (InputStream inputStream = url.openStream();
                 InputStreamReader reader = new InputStreamReader(inputStream);
                 UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)reader);){
                String line = null;
                while ((line = unsyncBufferedReader.readLine()) != null) {
                    line = line.trim();
                    int index = line.indexOf(32);
                    String serviceClassName = line;
                    String filterString = null;
                    if (index != -1) {
                        serviceClassName = line.substring(0, index);
                        filterString = line.substring(index + 1);
                    }
                    ServiceDependency serviceDependency = this._dependencyManager.createServiceDependency();
                    serviceDependency.setRequired(true);
                    Class<?> serviceClass = Class.forName(serviceClassName, false, classLoader);
                    serviceDependency.setService(serviceClass, filterString);
                    this._component.add(new Dependency[]{serviceDependency});
                }
            }
        }
    }
}

