/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.wedeploy.auth.web.internal.portlet.action;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.struts.BaseStrutsAction;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.wedeploy.auth.exception.NoSuchAppException;
import com.liferay.portal.security.wedeploy.auth.exception.NoSuchTokenException;
import com.liferay.portal.security.wedeploy.auth.model.WeDeployAuthToken;
import com.liferay.portal.security.wedeploy.auth.service.WeDeployAuthTokenLocalService;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"path=/portal/wedeploy/access_token"}, service={StrutsAction.class})
public class WeDeployAccessTokenAction
extends BaseStrutsAction {
    private static final Log _log = LogFactoryUtil.getLog(WeDeployAccessTokenAction.class);
    @Reference
    private WeDeployAuthTokenLocalService _weDeployAuthTokenLocalService;

    public String execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        String redirectURI = ParamUtil.getString((HttpServletRequest)request, (String)"redirect_uri");
        String clientId = ParamUtil.getString((HttpServletRequest)request, (String)"client_id");
        String clientSecret = ParamUtil.getString((HttpServletRequest)request, (String)"client_secret");
        String authorizationToken = ParamUtil.getString((HttpServletRequest)request, (String)"code");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)WeDeployAuthToken.class.getName(), (HttpServletRequest)request);
        try {
            WeDeployAuthToken weDeployAuthToken = this._weDeployAuthTokenLocalService.addAccessWeDeployAuthToken(redirectURI, clientId, clientSecret, authorizationToken, 1, serviceContext);
            jsonObject.put("access_token", weDeployAuthToken.getToken());
        }
        catch (NoSuchAppException nsae) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsae, (Throwable)nsae);
            }
            jsonObject.put("error_message", LanguageUtil.get((Locale)LocaleUtil.getDefault(), (String)"client-id-and-client-secret-do-not-match"));
        }
        catch (NoSuchTokenException nste) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nste, (Throwable)nste);
            }
            jsonObject.put("error_message", LanguageUtil.get((Locale)LocaleUtil.getDefault(), (String)"request-token-does-not-match"));
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            jsonObject.put("error_message", LanguageUtil.get((Locale)LocaleUtil.getDefault(), (String)"an-error-occurred-while-processing-the-requested-resource"));
        }
        ServletResponseUtil.write((HttpServletResponse)response, (String)jsonObject.toString());
        return null;
    }
}

