/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.event.generators.util;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRequestThreadLocal;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import java.util.List;

@ProviderType
public class AuditMessageBuilder {
    public static AuditMessage buildAuditMessage(String eventType, String className, long classPK, List<Attribute> attributes) {
        long companyId = CompanyThreadLocal.getCompanyId();
        long userId = 0L;
        if (PrincipalThreadLocal.getName() != null) {
            userId = GetterUtil.getLong((String)PrincipalThreadLocal.getName());
        }
        AuditRequestThreadLocal auditRequestThreadLocal = AuditRequestThreadLocal.getAuditThreadLocal();
        long realUserId = auditRequestThreadLocal.getRealUserId();
        String realUserName = PortalUtil.getUserName((long)realUserId, (String)"");
        JSONObject additionalInfoJSONObject = JSONFactoryUtil.createJSONObject();
        if (realUserId > 0L && userId != realUserId) {
            additionalInfoJSONObject.put("doAsUserId", String.valueOf(userId));
            additionalInfoJSONObject.put("doAsUserName", PortalUtil.getUserName((long)userId, (String)""));
        }
        if (attributes != null) {
            additionalInfoJSONObject.put("attributes", AuditMessageBuilder._getAttributesJSONArray(attributes));
        }
        return new AuditMessage(eventType, companyId, realUserId, realUserName, className, String.valueOf(classPK), null, additionalInfoJSONObject);
    }

    private static JSONArray _getAttributesJSONArray(List<Attribute> attributes) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (Attribute attribute : attributes) {
            JSONObject attributeJSONObject = JSONFactoryUtil.createJSONObject();
            attributeJSONObject.put("name", attribute.getName());
            attributeJSONObject.put("newValue", attribute.getNewValue());
            attributeJSONObject.put("oldValue", attribute.getOldValue());
            jsonArray.put(attributeJSONObject);
        }
        return jsonArray;
    }
}

