/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scripting.Scripting;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.scripting.ScriptingExecutor;
import com.liferay.portal.kernel.scripting.UnsupportedLanguageException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={Scripting.class})
public class ScriptingImpl
implements Scripting {
    private static final Log _log = LogFactoryUtil.getLog(ScriptingImpl.class);
    private final Map<String, ScriptingExecutor> _scriptingExecutors = new ConcurrentHashMap<String, ScriptingExecutor>();

    public void clearCache(String language) throws ScriptingException {
        ScriptingExecutor scriptingExecutor = this._scriptingExecutors.get(language);
        if (scriptingExecutor == null) {
            throw new UnsupportedLanguageException(language);
        }
        scriptingExecutor.clearCache();
    }

    public ScriptingExecutor createScriptingExecutor(String language, boolean executeInSeparateThread) {
        ScriptingExecutor scriptingExecutor = this._scriptingExecutors.get(language);
        return scriptingExecutor.newInstance(executeInSeparateThread);
    }

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, String language, String script) throws ScriptingException {
        ScriptingExecutor scriptingExecutor = this._scriptingExecutors.get(language);
        if (scriptingExecutor == null) {
            throw new UnsupportedLanguageException(language);
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            Map map = scriptingExecutor.eval(allowedClasses, inputObjects, outputNames, script);
            return map;
        }
        catch (Exception e) {
            throw new ScriptingException(this.getErrorMessage(script, e), (Throwable)e);
        }
        finally {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Evaluated script in " + stopWatch.getTime() + " ms"));
            }
        }
    }

    @Deprecated
    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, String language, String script, String ... servletContextNames) throws ScriptingException {
        return this.eval(allowedClasses, inputObjects, outputNames, language, script);
    }

    public void exec(Set<String> allowedClasses, Map<String, Object> inputObjects, String language, String script) throws ScriptingException {
        this.eval(allowedClasses, inputObjects, null, language, script);
    }

    @Deprecated
    public void exec(Set<String> allowedClasses, Map<String, Object> inputObjects, String language, String script, String ... servletContextNames) throws ScriptingException {
        this.eval(allowedClasses, inputObjects, null, language, script);
    }

    public Set<String> getSupportedLanguages() {
        return this._scriptingExecutors.keySet();
    }

    protected String getErrorMessage(String script, Exception e) {
        StringBundler sb = new StringBundler();
        sb.append(e.getMessage());
        sb.append("\n");
        try {
            String line;
            LineNumberReader lineNumberReader = new LineNumberReader((Reader)new UnsyncStringReader(script));
            while ((line = lineNumberReader.readLine()) != null) {
                sb.append("Line ");
                sb.append(lineNumberReader.getLineNumber());
                sb.append(": ");
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (IOException ioe) {
            sb.setIndex(0);
            sb.append(e.getMessage());
            sb.append("\n");
            sb.append(script);
        }
        return sb.toString();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setScriptingExecutors(ScriptingExecutor scriptingExecutor) {
        this._scriptingExecutors.put(scriptingExecutor.getLanguage(), scriptingExecutor);
    }

    protected void unsetScriptingExecutors(ScriptingExecutor scriptingExecutor) {
        this._scriptingExecutors.remove(scriptingExecutor.getLanguage());
    }
}

