/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassVisibilityChecker {
    public static final String ALL_CLASSES = "all_classes";
    private final boolean _allowAll;
    private final Set<Pattern> _allowedPatterns;
    private final boolean _denyAll;
    private final Set<String> _forbiddenClassNames;

    public ClassVisibilityChecker(Set<String> allowedClassNames, Set<String> forbiddenClassNames) {
        this._forbiddenClassNames = forbiddenClassNames;
        this._allowAll = allowedClassNames != null && allowedClassNames.contains(ALL_CLASSES);
        this._denyAll = this._forbiddenClassNames.contains(ALL_CLASSES);
        if (!this._allowAll && !this._denyAll) {
            this._allowedPatterns = new HashSet<Pattern>();
            for (String allowedClassName : allowedClassNames) {
                Pattern allowedPattern = Pattern.compile(allowedClassName);
                this._allowedPatterns.add(allowedPattern);
            }
        } else {
            this._allowedPatterns = null;
        }
    }

    public boolean isVisible(String className) {
        if (this._denyAll || this._forbiddenClassNames.contains(className)) {
            return false;
        }
        if (this._allowAll) {
            return true;
        }
        for (Pattern allowedPattern : this._allowedPatterns) {
            Matcher matcher = allowedPattern.matcher(className);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }
}

