/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.reports.engine.ReportDesignRetriever;
import com.liferay.portal.reports.engine.ReportEngine;
import com.liferay.portal.reports.engine.ReportGenerationException;
import com.liferay.portal.reports.engine.ReportRequest;
import com.liferay.portal.reports.engine.ReportResultContainer;

public class ReportRequestMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(ReportRequestMessageListener.class);
    private ReportEngine _reportEngine;
    private ReportResultContainer _reportResultContainer;

    public ReportRequestMessageListener() {
    }

    public ReportRequestMessageListener(ReportEngine reportEngine, ReportResultContainer reportResultContainer) {
        this._reportEngine = reportEngine;
        this._reportResultContainer = reportResultContainer;
    }

    public void setReportEngine(ReportEngine reportEngine) {
        this._reportEngine = reportEngine;
    }

    public void setReportResultContainer(ReportResultContainer reportResultContainer) {
        this._reportResultContainer = reportResultContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReceive(Message message) throws Exception {
        ReportRequest reportRequest = (ReportRequest)message.getPayload();
        ReportDesignRetriever reportDesignRetriever = reportRequest.getReportDesignRetriever();
        ReportResultContainer reportResultContainer = this._reportResultContainer.clone(reportDesignRetriever.getReportName());
        try {
            this._reportEngine.execute(reportRequest, reportResultContainer);
        }
        catch (ReportGenerationException reportGenerationException) {
            _log.error((Object)"Unable to generate report", (Throwable)((Object)reportGenerationException));
            reportResultContainer.setReportGenerationException(reportGenerationException);
        }
        finally {
            Message responseMessage = MessageBusUtil.createResponseMessage((Message)message);
            responseMessage.setPayload((Object)reportResultContainer);
            MessageBusUtil.sendMessage((String)responseMessage.getDestinationName(), (Message)responseMessage);
        }
    }
}

