/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine;

import com.liferay.portal.reports.engine.ReportFormat;
import com.liferay.portal.reports.engine.ReportFormatExporter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReportFormatExporterRegistry {
    private final Map<ReportFormat, ReportFormatExporter> _reportFormatExporters = new ConcurrentHashMap<ReportFormat, ReportFormatExporter>();

    public ReportFormatExporter getReportFormatExporter(ReportFormat reportFormat) {
        ReportFormatExporter reportFormatExporter = this._reportFormatExporters.get((Object)reportFormat);
        if (reportFormatExporter == null) {
            throw new IllegalArgumentException("No report format exporter found for " + (Object)((Object)reportFormat));
        }
        return reportFormatExporter;
    }

    protected void setReportFormatExporters(Map<String, ReportFormatExporter> reportFormatExporters) {
        for (Map.Entry<String, ReportFormatExporter> entry : reportFormatExporters.entrySet()) {
            ReportFormat reportFormat = ReportFormat.parse(entry.getKey());
            ReportFormatExporter reportFormatExporter = entry.getValue();
            this._reportFormatExporters.put(reportFormat, reportFormatExporter);
        }
    }
}

