/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.reports.engine.ReportGenerationException;
import com.liferay.portal.reports.engine.ReportResultContainer;
import java.io.OutputStream;
import java.io.Serializable;

public class ByteArrayReportResultContainer
implements ReportResultContainer,
Serializable {
    public static final int DEFAULT_INITIAL_CAPCITY = 15360;
    private final int _initialCapacity;
    private ReportGenerationException _reportGenerationException;
    private final String _reportName;
    private UnsyncByteArrayOutputStream _unsyncByteArrayOutputStream;

    public ByteArrayReportResultContainer() {
        this(null, 15360);
    }

    public ByteArrayReportResultContainer(String reportName) {
        this(reportName, 15360);
    }

    public ByteArrayReportResultContainer(String reportName, int initialCapacity) {
        this._reportName = reportName;
        this._initialCapacity = initialCapacity;
    }

    @Override
    public ReportResultContainer clone(String reportName) {
        return new ByteArrayReportResultContainer(reportName, this._initialCapacity);
    }

    @Override
    public OutputStream getOutputStream() {
        if (this._unsyncByteArrayOutputStream == null) {
            this._unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream(this._initialCapacity);
        }
        return this._unsyncByteArrayOutputStream;
    }

    @Override
    public ReportGenerationException getReportGenerationException() {
        return this._reportGenerationException;
    }

    @Override
    public String getReportName() {
        return this._reportName;
    }

    @Override
    public byte[] getResults() {
        return this._unsyncByteArrayOutputStream.toByteArray();
    }

    @Override
    public boolean hasError() {
        return this._reportGenerationException != null;
    }

    @Override
    public void setReportGenerationException(ReportGenerationException reportGenerationException) {
        this._reportGenerationException = reportGenerationException;
    }
}

