/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.debug.internal.osgi.commands;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.osgi.debug.SystemChecker;
import java.util.Collection;
import java.util.SortedMap;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;

@Component(immediate=true, property={"osgi.command.function=check", "osgi.command.scope=system"}, service={SystemCheckOSGiCommands.class})
public class SystemCheckOSGiCommands {
    private static final Log _log = LogFactoryUtil.getLog(SystemCheckOSGiCommands.class);
    private ServiceTracker<SystemChecker, SystemChecker> _serviceTracker;

    @Activate
    public void activate(BundleContext bundleContext) {
        this._serviceTracker = new ServiceTracker(bundleContext, SystemChecker.class, null);
        this._serviceTracker.open();
        if (_log.isInfoEnabled()) {
            _log.info((Object)"System check is enabled. You can run a system check with the command \"system:check\" in Gogo shell.");
        }
        if (GetterUtil.getBoolean((String)bundleContext.getProperty("initial.system.check.enabled"), (boolean)true)) {
            DependencyManagerSyncUtil.sync();
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Running system check");
            }
            this._check(false);
        }
    }

    public void check() {
        this._check(true);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    @Reference(target="(module.service.lifecycle=system.check)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    private void _check(boolean useSystemOut) {
        SortedMap systemCheckerMap = this._serviceTracker.getTracked();
        Collection systemCheckers = systemCheckerMap.values();
        if (useSystemOut) {
            System.out.println("Available checkers: " + systemCheckers);
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)("Available checkers :" + systemCheckers));
        }
        for (SystemChecker systemChecker : systemCheckers) {
            StringBundler sb = new StringBundler(5);
            sb.append("Running \"");
            sb.append(systemChecker.getName());
            sb.append("\". You can run this by itself with command \"");
            sb.append(systemChecker.getOSGiCommand());
            sb.append("\" in gogo shell.");
            if (useSystemOut) {
                System.out.println(sb.toString());
            } else if (_log.isInfoEnabled()) {
                _log.info((Object)sb.toString());
            }
            String result = systemChecker.check();
            if (Validator.isNull((String)result)) {
                if (useSystemOut) {
                    System.out.println(systemChecker.getName() + " check result: No issues were found.");
                    continue;
                }
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)(systemChecker.getName() + " check result: No issues were found."));
                continue;
            }
            if (useSystemOut) {
                System.out.println(systemChecker.getName() + " check result: " + result);
                continue;
            }
            if (!_log.isWarnEnabled()) continue;
            _log.warn((Object)(systemChecker.getName() + " check result: " + result));
        }
    }
}

