/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.error.code.internal.servlet.taglib;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.taglib.BaseJSPDynamicInclude;
import com.liferay.portal.kernel.servlet.taglib.DynamicInclude;
import com.liferay.portal.kernel.util.MapUtil;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"mime.type=text/html"}, service={DynamicInclude.class})
public class TextHTMLPortalErrorCodeJSPDynamicInclude
extends BaseJSPDynamicInclude {
    private static final String _CHARSET = "; charset=UTF-8";
    private static final Log _log = LogFactoryUtil.getLog(TextHTMLPortalErrorCodeJSPDynamicInclude.class);
    private String _contentType;
    private String _key;

    public void include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String key) throws IOException {
        httpServletResponse.setContentType(this._contentType);
        super.include(httpServletRequest, httpServletResponse, key);
    }

    public void register(DynamicInclude.DynamicIncludeRegistry dynamicIncludeRegistry) {
        dynamicIncludeRegistry.register(this._key);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        String mimeType = MapUtil.getString(properties, (String)"mime.type", null);
        if (mimeType == null) {
            throw new IllegalArgumentException("Mime type is null");
        }
        this._contentType = mimeType.concat(_CHARSET);
        this._key = "/errors/code.jsp#".concat(mimeType);
    }

    protected String getJspPath() {
        return "/dynamic_include/text_html.jsp";
    }

    protected Log getLog() {
        return _log;
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.portal.error.code)", unbind="-")
    protected void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
    }
}

